package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.model.core.events.AmityUserEvents
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Single

internal class UserTopicGeneratorUseCase: TopicGenerationUseCase() {

    fun execute(user: AmityUser, events: AmityUserEvents): Single<String> {
        val topic = when (events) {
            AmityUserEvents.USER -> {
                user.path
            }
            AmityUserEvents.POSTS -> {
                generateSocialPath(user) + "/post/+"
            }
            AmityUserEvents.COMMENTS -> {
                generateSocialPath(user) + "/post/+/comment/+"
            }
            AmityUserEvents.POSTS_AND_COMMENTS -> {
                generateSocialPath(user) + "/post/#"
            }
        }
        //AmityLog.tag("UserTopicGenUC").i( "generated topic: " + topic)
        return Single.just(topic)
    }

    private fun generateSocialPath(user: AmityUser) : String {
        val networkPath = user.path.substringBefore("/user")
        val userPath = user.path.substring(networkPath.length)
        return "$networkPath/social$userPath"
    }

}