package com.amity.socialcloud.sdk.core.data.settings.network.chat

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto
import io.reactivex.rxjava3.core.Completable

internal class ChatSettingsQueryPersister : QueryPersister<ChatSettingsDto>() {

    override fun persist(dto: ChatSettingsDto): Completable {
        return NetworkSettingsLocalDataStore().saveChatSettings(
            ChatSettingsEntityMapper().map(listOf(dto))
        )
    }
}