/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.SubChannelReadReceiptEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.SubChannelReadReceiptDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class SubChannelReadReceiptDao_Impl
extends SubChannelReadReceiptDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<SubChannelReadReceiptEntity> __insertAdapterOfSubChannelReadReceiptEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<SubChannelReadReceiptEntity> __deleteAdapterOfSubChannelReadReceiptEntity;
    private final EntityDeleteOrUpdateAdapter<SubChannelReadReceiptEntity> __updateAdapterOfSubChannelReadReceiptEntity;

    public SubChannelReadReceiptDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfSubChannelReadReceiptEntity = new EntityInsertAdapter<SubChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `read_receipt` (`subChannelId`,`latestSegment`,`latestSyncSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelReadReceiptEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                statement.bindLong(2, (long)entity.getLatestSegment());
                statement.bindLong(3, (long)entity.getLatestSyncSegment());
                String _tmp = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfSubChannelReadReceiptEntity = new EntityDeleteOrUpdateAdapter<SubChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `read_receipt` WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelReadReceiptEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfSubChannelReadReceiptEntity = new EntityDeleteOrUpdateAdapter<SubChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `read_receipt` SET `subChannelId` = ?,`latestSegment` = ?,`latestSyncSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelReadReceiptEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                statement.bindLong(2, (long)entity.getLatestSegment());
                statement.bindLong(3, (long)entity.getLatestSyncSegment());
                String _tmp = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = SubChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getSubChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(SubChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelReadReceiptEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends SubChannelReadReceiptEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelReadReceiptEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(SubChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelReadReceiptEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends SubChannelReadReceiptEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelReadReceiptEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(SubChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfSubChannelReadReceiptEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(SubChannelReadReceiptEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelReadReceiptDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends SubChannelReadReceiptEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelReadReceiptDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(SubChannelReadReceiptEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelReadReceiptDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public SubChannelReadReceiptEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from read_receipt where subChannelId = ? LIMIT 1";
        return (SubChannelReadReceiptEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from read_receipt where subChannelId = ? LIMIT 1");){
                SubChannelReadReceiptEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelReadReceiptEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _result.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelReadReceiptEntity subChannelReadReceiptEntity = _result;
                return subChannelReadReceiptEntity;
            }
        });
    }

    @Override
    public Flowable<SubChannelReadReceiptEntity> getById(String subChannelId) {
        String _sql = "SELECT * from read_receipt where subChannelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"read_receipt"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from read_receipt where subChannelId = ? LIMIT 1");){
                SubChannelReadReceiptEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelReadReceiptEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _result.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelReadReceiptEntity subChannelReadReceiptEntity = _result;
                return subChannelReadReceiptEntity;
            }
        });
    }

    @Override
    public List<SubChannelReadReceiptEntity> getUnsyncReadReceipts() {
        String _sql = "SELECT * from read_receipt where latestSyncSegment < latestSegment";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from read_receipt where latestSyncSegment < latestSegment");){
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<SubChannelReadReceiptEntity> _result = new ArrayList<SubChannelReadReceiptEntity>();
                while (_stmt.step()) {
                    SubChannelReadReceiptEntity _item = new SubChannelReadReceiptEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _item.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _item.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<SubChannelReadReceiptEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from read_receipt";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from read_receipt");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteBySubChannelId(String subChannelId) {
        String _sql = "DELETE from read_receipt where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from read_receipt where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateLatestSegment(String subChannelId, int segment) {
        String _sql = "UPDATE read_receipt set latestSegment = ? where subChannelId = ? and latestSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE read_receipt set latestSegment = ? where subChannelId = ? and latestSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)segment);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)segment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateLatestSyncSegment(String subChannelId, int segment) {
        String _sql = "UPDATE read_receipt set latestSyncSegment = ? where subChannelId = ? and latestSyncSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE read_receipt set latestSyncSegment = ? where subChannelId = ? and latestSyncSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)segment);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)segment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

