package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.joda.time.DateTime

@Entity(tableName = "pin", primaryKeys = ["pinId"])
data class PinEntity(
	val pinId: String,
	val referenceId: String,
	val referenceType: String,
	val placement: String,
	val targetId: String,
	val targetType: String,
	val pinnedBy: String,
	val pinnedAt: DateTime,
	val lastPinsUpdatedAt: DateTime,
) : EkoObject() {
	override fun getId(): String {
		return pinId
	}
	
	override fun equals(other: Any?): Boolean {
		if (other == null) return false
		if (other === this) return true
		return (other is PinEntity
			&& Objects.equal(pinId, other.pinId)
			&& Objects.equal(referenceId, other.referenceId)
			&& Objects.equal(referenceType, other.referenceType)
			&& Objects.equal(placement, other.placement)
			&& Objects.equal(targetId, other.targetId)
			&& Objects.equal(targetType, other.targetType)
			&& Objects.equal(pinnedBy, other.pinnedBy)
			&& Objects.equal(pinnedAt, other.pinnedAt)
			&& Objects.equal(lastPinsUpdatedAt, other.lastPinsUpdatedAt)
			&& Objects.equal(createdAt, other.createdAt)
			&& Objects.equal(updatedAt, other.updatedAt)
			)
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
			pinId,
			referenceId,
			referenceType,
			placement,
			targetId,
			targetType,
			pinnedBy,
			pinnedAt,
			lastPinsUpdatedAt,
			createdAt,
			updatedAt
		)
	}
}