package com.amity.socialcloud.sdk.entity.video.stream

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import com.google.gson.JsonArray
import org.amity.types.ObjectId


@Entity(tableName = "stream_moderation")
open class StreamModerationEntity : EkoObject() {

    @PrimaryKey
    var moderationId: String = ObjectId.get().toHexString()
    var streamId: String = ""
    var flagLabels: JsonArray? = null
    var terminateLabels: JsonArray? = null

    override fun getId(): String {
        return moderationId
    }
    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? StreamModerationEntity)?.let { streamModeration ->
            (Objects.equal(moderationId, streamModeration.moderationId)
                    && Objects.equal(flagLabels, streamModeration.flagLabels)
                    && Objects.equal(terminateLabels, streamModeration.terminateLabels))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(moderationId, streamId, flagLabels, terminateLabels)
    }
}