package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.video.RoomDto
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity

internal class RoomEntityMapper : EntityMapper<RoomDto, RoomEntity>() {
    override fun map(list: List<RoomDto>): List<RoomEntity> = list.map { map(it) }

    private fun map(dto: RoomDto): RoomEntity = RoomEntity().apply {
        roomId = dto.roomId ?: ""
        type = dto.type
        targetType = dto.targetType
        targetId = dto.targetId
        referenceType = dto.referenceType
        referenceId = dto.referenceId
        channelEnabled = dto.liveChatEnabled ?: false
        channelId = dto.liveChannelId
        title = dto.title
        description = dto.description
        thumbnailFileId = dto.thumbnailFileId
        status = dto.status
        participants = dto.participants
        livePlaybackUrl = dto.livePlaybackUrl
        durationSeconds = dto.durationSeconds
        parentRoomId = dto.parentRoomId
        childRoomIds = dto.childRoomIds
        creatorId = dto.createdBy
        isDeleted = dto.isDeleted
        deletedAt = dto.deletedAt
        deletedById = dto.deletedBy
        metadata = dto.metadata
        liveAt = dto.liveAt
        endedAt = dto.endedAt
        recordedAt = dto.recordedAt
        recordedUrl = dto.recordedPlaybackInfos?.map { it.url }
        recordedThumbnailUrl = dto.recordedPlaybackInfos?.map { it.thumbnailUrl }
        path = dto.path
        setCreatedAt(dto.createdAt)
        setUpdatedAt(dto.updatedAt)
    }
}

