package com.amity.socialcloud.sdk.core.data.analytics

import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.SendAnalyticsEventsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class AnalyticsRemoteDataStore {

    fun sendAnalyticsEvents(request: SendAnalyticsEventsRequest): Single<JsonObject> {
        return AmityHttpClient.get(AnalyticsApi::class).flatMap {
            it.sendAnalytics(request)
        }
    }

    fun getReachUsers(
        viewableItemType: AmityViewedType,
        viewableItemId: String,
        limit: Int?,
        token: String?
    ): Single<EkoUserListDto> {
        return AmityHttpClient.get(AnalyticsApi::class).flatMap {
            if(viewableItemType == AmityViewedType.POST) {
                it.queryPostReachUsers(
                    postId = viewableItemId,
                    limit = limit,
                    token = token
                )
            } else {
                it.queryStorySeenUsers(
                    storyId = viewableItemId,
                    limit = limit,
                    token = token
                )
            }
        }
    }
}