package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.data.invitation.InvitationQueryPersister
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class InvitationEventListener: MqttEventListener<InvitationsQueryDto>() {

    override val type: KClass<InvitationsQueryDto>
        get() = InvitationsQueryDto::class

    override fun processEvent(dto: InvitationsQueryDto) {
        InvitationQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: InvitationsQueryDto): Boolean {
        return true
    }

}