/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoUserFlagDao_Impl
extends EkoUserFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoUserFlag> __insertAdapterOfEkoUserFlag;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoUserFlag> __deleteAdapterOfEkoUserFlag;
    private final EntityDeleteOrUpdateAdapter<EkoUserFlag> __updateAdapterOfEkoUserFlag;

    public EkoUserFlagDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoUserFlag = new EntityInsertAdapter<EkoUserFlag>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_flag` (`userId`,`flag`,`localFlag`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFlag entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                String _tmp = EkoUserFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoUserFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfEkoUserFlag = new EntityDeleteOrUpdateAdapter<EkoUserFlag>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_flag` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFlag entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoUserFlag = new EntityDeleteOrUpdateAdapter<EkoUserFlag>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_flag` SET `userId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFlag entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                String _tmp = EkoUserFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoUserFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoUserFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoUserFlag.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoUserFlag> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoUserFlag.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoUserFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoUserFlag.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoUserFlag> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoUserFlag.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoUserFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoUserFlag.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoUserFlag object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoUserFlagDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoUserFlag> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoUserFlagDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoUserFlag object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoUserFlagDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    EkoUserFlag getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user_flag where userId = ? LIMIT 1";
        return (EkoUserFlag)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_flag where userId = ? LIMIT 1");){
                EkoUserFlag _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoUserFlag(_tmpUserId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFlag ekoUserFlag = _result;
                return ekoUserFlag;
            }
        });
    }

    @Override
    Flowable<EkoUserFlag> getByIdImpl(String userId) {
        String _sql = "SELECT * from user_flag where userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_flag"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_flag where userId = ? LIMIT 1");){
                EkoUserFlag _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoUserFlag(_tmpUserId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFlag ekoUserFlag = _result;
                return ekoUserFlag;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_flag";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_flag");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

