package com.amity.socialcloud.sdk.social.domain.post.update

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable

internal class PostEditUseCase {

    fun execute(
        postId: String,
        data: JsonObject,
        metadata: JsonObject? = null,
        mentionUserIds: List<String>? = null,
        attachments: List<AmityPostAttachment>? = null,
        hashtags: List<String>? = null,
    ): Completable {
        return PostRepository().editPost(
            postId = postId,
            data = data,
            metadata = metadata,
            mentionees = if(mentionUserIds.isNullOrEmpty()) {
                null
            } else {
                listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, mentionUserIds))
            },
            attachments = attachments,
            hashtags = hashtags,
        )
    }

}