package com.amity.socialcloud.sdk.chat.domain.marker.channel

import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerRepository

internal class UpdateChannelUnreadLastSegmentUseCase {

	fun execute(channelId: String, segment: Int) {
		val unread = ChannelMarkerRepository().getChannelUnread(channelId)
		unread?.let {
			if (unread.lastSegment < segment) {
				unread.lastSegment = segment
				ChannelMarkerRepository().saveChannelUnread(listOf(unread))
			}
		}
	}

}