/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoCategoryIds;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoCategoriesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoDiscussionCommunityDao;
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoDiscussionCommunityDao_Impl
extends EkoDiscussionCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<DiscussionCommunityEntity> __insertAdapterOfDiscussionCommunityEntity;
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoCategoriesTypeConverter __ekoCategoriesTypeConverter = new EkoCategoriesTypeConverter();
    private final EntityDeleteOrUpdateAdapter<DiscussionCommunityEntity> __deleteAdapterOfDiscussionCommunityEntity;
    private final EntityDeleteOrUpdateAdapter<DiscussionCommunityEntity> __updateAdapterOfDiscussionCommunityEntity;

    public EkoDiscussionCommunityDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfDiscussionCommunityEntity = new EntityInsertAdapter<DiscussionCommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `discussion_community` (`communityId`,`mid`,`path`,`channelId`,`userId`,`displayName`,`description`,`avatarFileId`,`isOfficial`,`isPublic`,`onlyAdminCanPost`,`tags`,`metadata`,`postsCount`,`membersCount`,`isJoined`,`isDeleted`,`needApprovalOnPostCreation`,`allowCommentInStory`,`editedAt`,`isDiscoverable`,`requiresJoinApproval`,`categoryIds`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull DiscussionCommunityEntity entity) {
                Integer _tmp_11;
                Integer _tmp_10;
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getDisplayName());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDescription());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getAvatarFileId());
                }
                Integer n = entity.isOfficial() == null ? null : (_tmp = Integer.valueOf(entity.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = entity.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(entity.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = entity.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(entity.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoDiscussionCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                String _tmp_4 = EkoDiscussionCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_4);
                }
                if (entity.getPostsCount() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getPostsCount().intValue());
                }
                if (entity.getMembersCount() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindLong(15, (long)entity.getMembersCount().intValue());
                }
                Integer n4 = entity.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(entity.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = entity.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(entity.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = entity.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(entity.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = entity.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(entity.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_9);
                }
                Integer n8 = entity.isDiscoverable() == null ? null : (_tmp_10 = Integer.valueOf(entity.isDiscoverable() != false ? 1 : 0));
                if (_tmp_10 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_10.intValue());
                }
                Integer n9 = entity.getRequiresJoinApproval() == null ? null : (_tmp_11 = Integer.valueOf(entity.getRequiresJoinApproval() != false ? 1 : 0));
                if (_tmp_11 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_11.intValue());
                }
                String _tmp_12 = EkoDiscussionCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(entity.getCategoryIds());
                if (_tmp_12 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_12);
                }
                String _tmp_13 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_13 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_13);
                }
                String _tmp_14 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_14 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_14);
                }
                String _tmp_15 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_15 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_15);
                }
            }
        };
        this.__deleteAdapterOfDiscussionCommunityEntity = new EntityDeleteOrUpdateAdapter<DiscussionCommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `discussion_community` WHERE `communityId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull DiscussionCommunityEntity entity) {
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfDiscussionCommunityEntity = new EntityDeleteOrUpdateAdapter<DiscussionCommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `discussion_community` SET `communityId` = ?,`mid` = ?,`path` = ?,`channelId` = ?,`userId` = ?,`displayName` = ?,`description` = ?,`avatarFileId` = ?,`isOfficial` = ?,`isPublic` = ?,`onlyAdminCanPost` = ?,`tags` = ?,`metadata` = ?,`postsCount` = ?,`membersCount` = ?,`isJoined` = ?,`isDeleted` = ?,`needApprovalOnPostCreation` = ?,`allowCommentInStory` = ?,`editedAt` = ?,`isDiscoverable` = ?,`requiresJoinApproval` = ?,`categoryIds` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `communityId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull DiscussionCommunityEntity entity) {
                Integer _tmp_11;
                Integer _tmp_10;
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getDisplayName());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDescription());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getAvatarFileId());
                }
                Integer n = entity.isOfficial() == null ? null : (_tmp = Integer.valueOf(entity.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = entity.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(entity.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = entity.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(entity.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoDiscussionCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                String _tmp_4 = EkoDiscussionCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_4);
                }
                if (entity.getPostsCount() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getPostsCount().intValue());
                }
                if (entity.getMembersCount() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindLong(15, (long)entity.getMembersCount().intValue());
                }
                Integer n4 = entity.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(entity.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = entity.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(entity.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = entity.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(entity.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = entity.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(entity.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_9);
                }
                Integer n8 = entity.isDiscoverable() == null ? null : (_tmp_10 = Integer.valueOf(entity.isDiscoverable() != false ? 1 : 0));
                if (_tmp_10 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_10.intValue());
                }
                Integer n9 = entity.getRequiresJoinApproval() == null ? null : (_tmp_11 = Integer.valueOf(entity.getRequiresJoinApproval() != false ? 1 : 0));
                if (_tmp_11 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_11.intValue());
                }
                String _tmp_12 = EkoDiscussionCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(entity.getCategoryIds());
                if (_tmp_12 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_12);
                }
                String _tmp_13 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_13 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_13);
                }
                String _tmp_14 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_14 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_14);
                }
                String _tmp_15 = EkoDiscussionCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_15 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_15);
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, entity.getCommunityId());
                }
            }
        };
    }

    @Override
    public void insertImpl(DiscussionCommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfDiscussionCommunityEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends DiscussionCommunityEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfDiscussionCommunityEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(DiscussionCommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfDiscussionCommunityEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends DiscussionCommunityEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfDiscussionCommunityEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(DiscussionCommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfDiscussionCommunityEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(DiscussionCommunityEntity community) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoDiscussionCommunityDao_Impl.super.insert(community);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends DiscussionCommunityEntity> communities) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoDiscussionCommunityDao_Impl.super.insert(communities);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(DiscussionCommunityEntity community) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoDiscussionCommunityDao_Impl.super.update(community);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(List<? extends DiscussionCommunityEntity> communities) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoDiscussionCommunityDao_Impl.super.update(communities);
            return Unit.INSTANCE;
        });
    }

    @Override
    Flowable<DiscussionCommunityEntity> getByCommunityIdImpl(String communityId) {
        String _sql = "SELECT * from discussion_community where discussion_community.communityId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"discussion_community"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from discussion_community where discussion_community.communityId = ? LIMIT 1");){
                DiscussionCommunityEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new DiscussionCommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _result.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _result.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _result.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _result.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _result.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _result.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _result.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _result.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                DiscussionCommunityEntity discussionCommunityEntity = _result;
                return discussionCommunityEntity;
            }
        });
    }

    @Override
    DiscussionCommunityEntity getByIdNowImpl(String communityId) {
        String _sql = "SELECT * from discussion_community where communityId = ? LIMIT 1";
        return (DiscussionCommunityEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from discussion_community where communityId = ? LIMIT 1");){
                DiscussionCommunityEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new DiscussionCommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _result.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _result.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _result.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _result.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _result.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _result.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _result.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _result.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                DiscussionCommunityEntity discussionCommunityEntity = _result;
                return discussionCommunityEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from discussion_community";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from discussion_community");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    Completable deleteByCommunityIdImpl(String communityId) {
        String _sql = "UPDATE discussion_community set isDeleted = 1 where communityId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE discussion_community set isDeleted = 1 where communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void notifyChanges(String communityId) {
        String _sql = "UPDATE discussion_community set communityId = ? where communityId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE discussion_community set communityId = ? where communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

