/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.unread.Unread;
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.ChannelUnreadInfoDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class ChannelUnreadInfoDao_Impl
extends ChannelUnreadInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChannelUnreadInfoEntity> __insertAdapterOfChannelUnreadInfoEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChannelUnreadInfoEntity> __deleteAdapterOfChannelUnreadInfoEntity;
    private final EntityDeleteOrUpdateAdapter<ChannelUnreadInfoEntity> __updateAdapterOfChannelUnreadInfoEntity;

    public ChannelUnreadInfoDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChannelUnreadInfoEntity = new EntityInsertAdapter<ChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_unread_info` (`channelId`,`unreadCount`,`isMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadInfoEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                String _tmp_1 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfChannelUnreadInfoEntity = new EntityDeleteOrUpdateAdapter<ChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_unread_info` WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadInfoEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelUnreadInfoEntity = new EntityDeleteOrUpdateAdapter<ChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_unread_info` SET `channelId` = ?,`unreadCount` = ?,`isMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadInfoEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                String _tmp_1 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelUnreadInfoEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChannelUnreadInfoEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelUnreadInfoEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelUnreadInfoEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChannelUnreadInfoEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelUnreadInfoEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChannelUnreadInfoEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChannelUnreadInfoEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadInfoDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChannelUnreadInfoEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadInfoDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(ChannelUnreadInfoEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadInfoDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<ChannelUnreadInfoEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_unread_info where channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread_info"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_unread_info where channelId = ? LIMIT 1");){
                ChannelUnreadInfoEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelUnreadInfoEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelUnreadInfoEntity channelUnreadInfoEntity = _result;
                return channelUnreadInfoEntity;
            }
        });
    }

    @Override
    public ChannelUnreadInfoEntity getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from channel_unread_info where channelId = ? LIMIT 1";
        return (ChannelUnreadInfoEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_unread_info where channelId = ? LIMIT 1");){
                ChannelUnreadInfoEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelUnreadInfoEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelUnreadInfoEntity channelUnreadInfoEntity = _result;
                return channelUnreadInfoEntity;
            }
        });
    }

    @Override
    public Flowable<Unread> getTotalChannelsUnreadInfo() {
        String _sql = "SELECT COALESCE(SUM(channel_unread_info.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread_info.isMentioned), 0) as isMentioned from channel_unread_info where channel_unread_info.channelId in (SELECT channelId from channel)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread_info", "channel"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT COALESCE(SUM(channel_unread_info.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread_info.isMentioned), 0) as isMentioned from channel_unread_info where channel_unread_info.channelId in (SELECT channelId from channel)");){
                Unread _result;
                boolean _columnIndexOfUnreadCount = false;
                boolean _columnIndexOfIsMentioned = true;
                if (_stmt.step()) {
                    int _tmpUnreadCount = (int)_stmt.getLong(0);
                    int _tmp = (int)_stmt.getLong(1);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result = new Unread(_tmpUnreadCount, _tmpIsMentioned);
                } else {
                    _result = null;
                }
                Unread unread = _result;
                return unread;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_unread_info";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_unread_info");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String channelId) {
        String _sql = "DELETE from channel_unread_info where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_unread_info where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

