/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.room;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH'J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH'J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rH'J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0012\u001a\u00020\u0013H'J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH'J\b\u0010\u0018\u001a\u00020\u0016H'\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/video/data/room/RoomDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/amity/socialcloud/sdk/entity/video/room/RoomEntity;", "<init>", "()V", "getByIdImpl", "Lio/reactivex/rxjava3/core/Flowable;", "roomId", "", "getById", "getByIdNowImpl", "getByIdNow", "getByIdsNowImpl", "", "roomIds", "getByIdsNow", "getLatestRoomImpl", "statuses", "now", "Lorg/joda/time/DateTime;", "getLatestRoom", "updateRoom", "", "updateRoomImpl", "deleteAll", "amity-sdk_release"})
@Dao
public abstract class RoomDao
extends EkoObjectDao<RoomEntity> {
    @Query(value="SELECT * FROM room WHERE roomId = :roomId")
    @NotNull
    public abstract Flowable<RoomEntity> getByIdImpl(@NotNull String var1);

    @NotNull
    public final Flowable<RoomEntity> getById(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return this.getByIdImpl(roomId);
    }

    @Query(value="SELECT * FROM room WHERE roomId = :roomId")
    @Nullable
    public abstract RoomEntity getByIdNowImpl(@NotNull String var1);

    @Override
    @Nullable
    public RoomEntity getByIdNow(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return this.getByIdNowImpl(roomId);
    }

    @Query(value="SELECT * FROM room WHERE roomId in (:roomIds)")
    @NotNull
    public abstract List<RoomEntity> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    @NotNull
    public List<RoomEntity> getByIdsNow(@NotNull List<String> roomIds) {
        Intrinsics.checkNotNullParameter(roomIds, (String)"roomIds");
        return this.getByIdsNowImpl(roomIds);
    }

    @Query(value="SELECT * FROM room WHERE status in (:statuses) AND room.updatedAt > :now ORDER BY room.updatedAt DESC LIMIT 1")
    @NotNull
    public abstract Flowable<RoomEntity> getLatestRoomImpl(@NotNull List<String> var1, @NotNull DateTime var2);

    @NotNull
    public final Flowable<RoomEntity> getLatestRoom(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        return this.getLatestRoomImpl(statuses, dateTime);
    }

    @Transaction
    public void updateRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        this.updateRoomImpl(roomId);
    }

    @Query(value="UPDATE room set roomId = :roomId where roomId = :roomId")
    public abstract void updateRoomImpl(@NotNull String var1);

    @Override
    @Query(value="DELETE FROM room")
    public abstract void deleteAll();
}

