/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.social.data.event.EventLocalDataStore;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore;", "", "<init>", "()V", "saveEvent", "Lio/reactivex/rxjava3/core/Completable;", "event", "Lcom/amity/socialcloud/sdk/entity/social/event/EventEntity;", "saveEvents", "events", "", "getEvent", "eventId", "", "observeEvent", "Lio/reactivex/rxjava3/core/Flowable;", "deleteEvent", "clear", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n72#2,2:96\n72#2,2:100\n72#2,2:104\n1#3:98\n1#3:102\n1#3:106\n1#3:107\n1869#4:99\n1870#4:103\n1869#4,2:108\n*S KotlinDebug\n*F\n+ 1 EventLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore\n*L\n31#1:96,2\n44#1:100,2\n58#1:104,2\n31#1:98\n44#1:102\n58#1:106\n40#1:99\n40#1:103\n90#1:108,2\n*E\n"})
public final class EventLocalDataStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<String, EventEntity> eventCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, BehaviorSubject<EventEntity>> eventSubjects = new ConcurrentHashMap();

    @NotNull
    public final Completable saveEvent(@NotNull EventEntity event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Completable completable = Completable.fromAction(() -> EventLocalDataStore.saveEvent$lambda$1(event)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable saveEvents(@NotNull List<EventEntity> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Completable completable = Completable.fromAction(() -> EventLocalDataStore.saveEvents$lambda$4(events)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @Nullable
    public final EventEntity getEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return eventCache.get(eventId);
    }

    @NotNull
    public final Flowable<EventEntity> observeEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Flowable flowable = Flowable.defer(() -> EventLocalDataStore.observeEvent$lambda$7(eventId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"subscribeOn(...)");
        return flowable;
    }

    @NotNull
    public final Completable deleteEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Completable completable = Completable.fromAction(() -> EventLocalDataStore.deleteEvent$lambda$8(eventId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable clear() {
        Completable completable = Completable.fromAction(EventLocalDataStore::clear$lambda$10).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveEvent$lambda$1(EventEntity $event) {
        void $this$getOrPut$iv;
        ((Map)eventCache).put($event.getEventId(), $event);
        ConcurrentMap concurrentMap = eventSubjects;
        String key$iv = $event.getEventId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            BehaviorSubject default$iv = BehaviorSubject.create();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BehaviorSubject subject = (BehaviorSubject)object;
        subject.onNext((Object)$event);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveEvents$lambda$4(List $events) {
        Iterable $this$forEach$iv = $events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$getOrPut$iv;
            EventEntity event = (EventEntity)element$iv;
            boolean bl = false;
            ((Map)eventCache).put(event.getEventId(), event);
            ConcurrentMap concurrentMap = eventSubjects;
            String key$iv = event.getEventId();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                BehaviorSubject default$iv = BehaviorSubject.create();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            BehaviorSubject subject = (BehaviorSubject)object;
            subject.onNext((Object)event);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher observeEvent$lambda$7(String $eventId) {
        BehaviorSubject subject;
        block2: {
            void $this$getOrPut$iv;
            ConcurrentMap concurrentMap = eventSubjects;
            String key$iv = $eventId;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                BehaviorSubject default$iv = BehaviorSubject.create();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            subject = (BehaviorSubject)object;
            EventEntity eventEntity = eventCache.get($eventId);
            if (eventEntity == null) break block2;
            EventEntity it = eventEntity;
            boolean bl = false;
            subject.onNext((Object)it);
        }
        return (Publisher)subject.toFlowable(BackpressureStrategy.LATEST).map((Function)observeEvent.1.2.INSTANCE);
    }

    private static final void deleteEvent$lambda$8(String $eventId) {
        eventCache.remove($eventId);
        BehaviorSubject<EventEntity> behaviorSubject = eventSubjects.get($eventId);
        if (behaviorSubject != null) {
            behaviorSubject.onComplete();
        }
        eventSubjects.remove($eventId);
    }

    private static final void clear$lambda$10() {
        eventCache.clear();
        Collection<BehaviorSubject<EventEntity>> collection = eventSubjects.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BehaviorSubject it = (BehaviorSubject)element$iv;
            boolean bl = false;
            it.onComplete();
        }
        eventSubjects.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore$Companion;", "", "<init>", "()V", "eventCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/amity/socialcloud/sdk/entity/social/event/EventEntity;", "eventSubjects", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

