/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.marker.message;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter;
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.MessageMarkerEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.MessageMarkerDao;
import io.reactivex.rxjava3.core.Completable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0014\u0010\f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bJ(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/marker/message/MessageMarkerLocalDataStore;", "", "<init>", "()V", "getMessageMarker", "Lcom/ekoapp/ekosdk/internal/MessageMarkerEntity;", "messageId", "", "saveMessageMarkers", "Lio/reactivex/rxjava3/core/Completable;", "messageMarkers", "", "saveAndUpdatePreviousMessageMarkers", "saveAndUpdatePreviousMessageMarker", "", "marker", "saveLocalMessageMarkers", "markers", "getMessageReadUsersPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/amity/socialcloud/sdk/entity/core/user/UserEntity;", "memberships", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageReadMembershipFilter;", "getMessageDeliveredUsersPagingSource", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageDeliveredMembershipFilter;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMessageMarkerLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageMarkerLocalDataStore.kt\ncom/amity/socialcloud/sdk/chat/data/marker/message/MessageMarkerLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1563#2:84\n1634#2,3:85\n*S KotlinDebug\n*F\n+ 1 MessageMarkerLocalDataStore.kt\ncom/amity/socialcloud/sdk/chat/data/marker/message/MessageMarkerLocalDataStore\n*L\n30#1:84\n30#1:85,3\n*E\n"})
public final class MessageMarkerLocalDataStore {
    @Nullable
    public final MessageMarkerEntity getMessageMarker(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return UserDatabase.get().messageMarkerDao().getByIdNow(messageId);
    }

    @NotNull
    public final Completable saveMessageMarkers(@NotNull List<? extends MessageMarkerEntity> messageMarkers) {
        Intrinsics.checkNotNullParameter(messageMarkers, (String)"messageMarkers");
        Completable completable = Completable.fromAction(() -> MessageMarkerLocalDataStore.saveMessageMarkers$lambda$0(messageMarkers));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable saveAndUpdatePreviousMessageMarkers(@NotNull List<? extends MessageMarkerEntity> messageMarkers) {
        Intrinsics.checkNotNullParameter(messageMarkers, (String)"messageMarkers");
        Completable completable = Completable.fromAction(() -> MessageMarkerLocalDataStore.saveAndUpdatePreviousMessageMarkers$lambda$1(messageMarkers, this));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    public final void saveAndUpdatePreviousMessageMarker(@NotNull MessageMarkerEntity marker) {
        EkoMessageEntity message;
        EkoMessageEntity ekoMessageEntity;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        EkoMessageDao messageDao = UserDatabase.get().messageDao();
        try {
            ekoMessageEntity = messageDao.getByMessageIdNow(marker.getMessageId());
        }
        catch (Exception e) {
            ekoMessageEntity = null;
        }
        EkoMessageEntity ekoMessageEntity2 = message = ekoMessageEntity;
        boolean isCreator = Intrinsics.areEqual((Object)(ekoMessageEntity2 != null ? ekoMessageEntity2.getUserId() : null), (Object)AmityCoreClient.INSTANCE.getUserId());
        MessageMarkerDao messageMarkerDao = UserDatabase.get().messageMarkerDao();
        if (isCreator) {
            messageMarkerDao.save(CollectionsKt.listOf((Object)marker));
        }
        String string = marker.getSubChannelId();
        int n = marker.getReadCount();
        DateTime dateTime = marker.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"getCreatedAt(...)");
        messageMarkerDao.updatePreviousMarkersReadCount(string, n, dateTime);
        String string2 = marker.getSubChannelId();
        int n2 = marker.getDeliveredCount();
        DateTime dateTime2 = marker.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"getCreatedAt(...)");
        messageMarkerDao.updatePreviousMarkersDeliveredCount(string2, n2, dateTime2);
    }

    public final void saveLocalMessageMarkers(@NotNull List<? extends MessageMarkerEntity> markers) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        UserDatabase.get().messageMarkerDao().save(markers);
    }

    @NotNull
    public final PagingSource<Integer, UserEntity> getMessageReadUsersPagingSource(@NotNull String messageId, @NotNull List<? extends MessageReadMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        return UserDatabase.get().messageReadUsersPagingDao().getMessageReadUsersPagingSource(messageId, memberships);
    }

    @NotNull
    public final PagingSource<Integer, UserEntity> getMessageDeliveredUsersPagingSource(@NotNull String messageId, @NotNull List<? extends MessageDeliveredMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        return UserDatabase.get().messageDeliveredUsersPagingDao().getMessageDeliveredUsersPagingSource(messageId, memberships);
    }

    private static final void saveMessageMarkers$lambda$0(List $messageMarkers) {
        UserDatabase.get().messageMarkerDao().save($messageMarkers);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveAndUpdatePreviousMessageMarkers$lambda$1(List $messageMarkers, MessageMarkerLocalDataStore this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $messageMarkers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MessageMarkerEntity messageMarkerEntity = (MessageMarkerEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this$0.saveAndUpdatePreviousMessageMarker((MessageMarkerEntity)p0);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }
}

