package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryEntity;
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity;

import java.util.List;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;


@Dao
public abstract class EkoDiscussionCommunityDao extends EkoObjectDao<DiscussionCommunityEntity> {

    private final EkoCommunityWithCategoryDao communityWithCategoryDao = UserDatabase.get().communityWithCategoryDao();

    @Query("DELETE from discussion_community")
    public abstract void deleteAll();

    @Query("UPDATE discussion_community set isDeleted = 1 where communityId = :communityId")
    abstract Completable deleteByCommunityIdImpl(String communityId);

    public Completable deleteByCommunityId(String communityId) {
        return deleteByCommunityIdImpl(communityId);
    }

    @Query("SELECT *" +
            " from discussion_community" +
            " where discussion_community.communityId = :communityId" +
            " LIMIT 1")
    abstract Flowable<DiscussionCommunityEntity> getByCommunityIdImpl(String communityId);

    public Flowable<DiscussionCommunityEntity> getByCommunityId(String communityId) {
        return getByCommunityIdImpl(communityId);
    }

    @Transaction
    @Override
    public void insert(DiscussionCommunityEntity community) {
        super.insert(community);
        EkoCategoryDao.update(community, communityWithCategoryDao, EkoCategoryEntity::create);
    }


    @Transaction
    @Override
    public void insert(@NonNull List<? extends DiscussionCommunityEntity> communities) {
        super.insert(communities);
        EkoCategoryDao.update(communities, communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Transaction
    @Override
    public void update(DiscussionCommunityEntity community) {
        super.update(community);
        EkoCategoryDao.update(community, communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Transaction
    @Override
    public void update(@NonNull List<? extends DiscussionCommunityEntity> communities) {
        super.update(communities);
        EkoCategoryDao.update(communities, communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Query("SELECT * from discussion_community where communityId = :communityId LIMIT 1")
    abstract DiscussionCommunityEntity getByIdNowImpl(String communityId);

    public DiscussionCommunityEntity getByIdNow(String communityId) {
        return getByIdNowImpl(communityId);
    }

    @Query("UPDATE discussion_community set communityId = :communityId where communityId = :communityId")
    public abstract void notifyChanges(String communityId);

}
