package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class GetRoomNowUseCase {
    fun execute(roomId: String): AmityRoom? = RoomRepository().getRoomsByIds(listOf(roomId)).firstOrNull()
        ?.let { RoomComposerUseCase().execute(it) }
}
