package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper

internal class EventComposerUseCase : ComposerUseCase() {

    fun execute(event: AmityEvent): AmityEvent {
        addCreator(event)
        addCoverImage(event)
        addTargetCommunity(event)
        return event
    }

    private fun addCreator(event: AmityEvent) {
        event.creator = UserGetUseCase().execute(event.getUserId())
    }
    
    private fun addCoverImage(event: AmityEvent) {
        event.getCoverImageFileId()?.let { fileId ->
            event.coverImage = ImageGetUseCase().execute(fileId)
        }
    }
    
    private fun addTargetCommunity(event: AmityEvent) {
        if (event.getOriginType() == AmityEventOriginType.COMMUNITY) {
            val communityEntity = CommunityLocalDataStore().getCommunityById(event.getOriginId())
            communityEntity?.let {
                event.targetCommunity = CommunityModelMapper().map(it)
            }
        }
    }
}
