package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVP
import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVPStatus
import com.ekoapp.ekosdk.internal.api.dto.EventRSVPDto
import io.reactivex.rxjava3.core.Single

internal class EventRSVPRepository {

    // fun createRSVP(
    //     eventId: String,
    //     status: AmityEventRSVPStatus
    // ): Single<AmityEventRSVP> {
    //     return EventRemoteDataStore().createRSVP(eventId, status)
    //         .flatMap { dto ->
    //             EventRSVPQueryPersister().persist(dto)
    //                 .andThen(
    //                     dto.rsvps?.firstOrNull()?.let { rsvpDto ->
    //                         Single.just(mapToAmityEventRSVP(rsvpDto))
    //                     } ?: Single.error(Exception("No RSVPs in response"))
    //                 )
    //         }
    // }

    // fun updateRSVP(
    //     eventId: String,
    //     status: AmityEventRSVPStatus
    // ): Single<AmityEventRSVP> {
    //     return EventRemoteDataStore().updateRSVP(eventId, status)
    //         .flatMap { dto ->
    //             EventRSVPQueryPersister().persist(dto)
    //                 .andThen(
    //                     dto.rsvps?.firstOrNull()?.let { rsvpDto ->
    //                         Single.just(mapToAmityEventRSVP(rsvpDto))
    //                     } ?: Single.error(Exception("No RSVPs in response"))
    //                 )
    //         }
    // }

    private fun mapToAmityEventRSVP(dto: EventRSVPDto): AmityEventRSVP {
        return AmityEventRSVP(
            rsvpId = dto.rsvpId ?: "",
            status = AmityEventRSVPStatus.enumOf(dto.status),
            eventId = dto.eventId ?: "",
            event = null,
            userId = dto.userId ?: "",
            user = null,
            createdAt = dto.createdAt ?: org.joda.time.DateTime.now(),
            updatedAt = dto.updatedAt ?: org.joda.time.DateTime.now(),
            path = dto.path ?: ""
        )
    }
}
