package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus
import com.amity.socialcloud.sdk.model.social.event.AmityEventType

internal class EventModelMapper : ModelMapper<EventEntity, AmityEvent>() {

    override fun map(entity: EventEntity): AmityEvent {
        return entity.run {
            AmityEvent(
                publicId = publicId,
                eventId = eventId,
                title = title,
                description = description,
                type = AmityEventType.enumOf(type),
                status = AmityEventStatus.enumOf(status),
                startTime = startTime,
                endTime = endTime,
                coverImageFileId = coverImageFileId,
                coverImage = null,
                originType = AmityEventOriginType.enumOf(originType),
                originId = originId,
                userId = userId,
                creator = null,
                discussionCommunityId = discussionCommunityId,
                targetCommunity = null,
                postId = postId,
                rsvpCount = rsvpCount,
                interestedCount = interestedCount,
                isLocationVisible = isLocationVisible,
                location = location,
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path
            )
        }
    }
}
