/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoDiscussionCommunityDao;
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/DiscussionCommunityLocalDataStore;", "", "<init>", "()V", "getDiscussionCommunity", "Lcom/ekoapp/ekosdk/internal/entity/DiscussionCommunityEntity;", "communityId", "", "observeDiscussionCommunity", "Lio/reactivex/rxjava3/core/Flowable;", "saveDiscussionCommunities", "Lio/reactivex/rxjava3/core/Completable;", "communities", "", "deleteDiscussionCommunity", "hasInLocal", "", "notifyChanges", "", "amity-sdk_release"})
public final class DiscussionCommunityLocalDataStore {
    @Nullable
    public final DiscussionCommunityEntity getDiscussionCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Ref.ObjectRef community = new Ref.ObjectRef();
        Completable.fromCallable(() -> DiscussionCommunityLocalDataStore.getDiscussionCommunity$lambda$0(communityId, community)).subscribeOn(Schedulers.io()).blockingAwait();
        return (DiscussionCommunityEntity)community.element;
    }

    @NotNull
    public final Flowable<DiscussionCommunityEntity> observeDiscussionCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Flowable<DiscussionCommunityEntity> flowable = UserDatabase.get().discussionCommunityDao().getByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getByCommunityId(...)");
        return flowable;
    }

    @NotNull
    public final Completable saveDiscussionCommunities(@NotNull List<? extends DiscussionCommunityEntity> communities) {
        Intrinsics.checkNotNullParameter(communities, (String)"communities");
        Completable completable = Completable.fromAction(() -> DiscussionCommunityLocalDataStore.saveDiscussionCommunities$lambda$1(communities));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteDiscussionCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = UserDatabase.get().discussionCommunityDao().deleteByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"deleteByCommunityId(...)");
        return completable;
    }

    public final boolean hasInLocal(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        EkoDiscussionCommunityDao discussionCommunityDao = UserDatabase.get().discussionCommunityDao();
        return discussionCommunityDao.getByIdNow(communityId) != null;
    }

    public final void notifyChanges(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        UserDatabase.get().discussionCommunityDao().notifyChanges(communityId);
    }

    private static final Unit getDiscussionCommunity$lambda$0(String $communityId, Ref.ObjectRef $community) {
        EkoDiscussionCommunityDao discussionCommunityDao = UserDatabase.get().discussionCommunityDao();
        DiscussionCommunityEntity entity = discussionCommunityDao.getByIdNow($communityId);
        if (entity != null) {
            $community.element = entity;
        }
        return Unit.INSTANCE;
    }

    private static final void saveDiscussionCommunities$lambda$1(List $communities) {
        UserDatabase.get().discussionCommunityDao().save($communities);
    }
}

