/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository;
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository;
import com.amity.socialcloud.sdk.chat.domain.message.preview.MessageEventToMessagePreviewUseCase;
import com.amity.socialcloud.sdk.chat.domain.message.preview.MessagePreviewSaveUseCase;
import com.amity.socialcloud.sdk.chat.domain.message.preview.MessagePreviewUpdatedUseCase;
import com.amity.socialcloud.sdk.core.MessagePreviewEvent;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessagePreview;
import com.amity.socialcloud.sdk.model.chat.settings.AmityChatSettings;
import com.amity.socialcloud.sdk.model.chat.settings.AmityMessagePreviewSetting;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity;
import com.ekoapp.ekosdk.internal.usecase.user.GetChatSettingsUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/core/MessagePreviewEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "isActive", "", "messagePreviewSetting", "Lcom/amity/socialcloud/sdk/model/chat/settings/AmityMessagePreviewSetting;", "handleMessagePreviewEvent", "Lio/reactivex/rxjava3/core/Completable;", "event", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent;", "handleMessageCreatedEvent", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent$MessageCreated;", "handleMessageUpdated", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent$MessageUpdated;", "handleMessageDeleted", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent$MessageDeleted;", "handleSubChannelUpdated", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent$SubChannelUpdated;", "handleSubChannelDeleted", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEvent$SubChannelDeleted;", "fetchSubChannelIfNeeded", "fetchChatSettings", "", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMessagePreviewEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagePreviewEngine.kt\ncom/amity/socialcloud/sdk/core/MessagePreviewEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class MessagePreviewEngine
extends SessionComponent {
    private boolean isActive;
    @Nullable
    private AmityMessagePreviewSetting messagePreviewSetting;

    public MessagePreviewEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.isActive = Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE);
        if (this.isActive) {
            this.fetchChatSettings();
        }
        MessagePreviewEventBus.INSTANCE.observe().flatMapCompletable(new Function(){

            public final CompletableSource apply(MessagePreviewEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return (CompletableSource)this.handleMessagePreviewEvent(event).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable handleMessagePreviewEvent(MessagePreviewEvent event) {
        Completable completable;
        if (event instanceof MessagePreviewEvent.MessagePreviewSettingChange) {
            switch (WhenMappings.$EnumSwitchMapping$0[((MessagePreviewEvent.MessagePreviewSettingChange)event).getMessagePreviewSetting().ordinal()]) {
                case 1: {
                    Completable completable2 = Completable.fromCallable(MessagePreviewEngine::handleMessagePreviewEvent$lambda$0);
                    Intrinsics.checkNotNull((Object)completable2);
                    completable = completable2;
                    break;
                }
                case 2: {
                    Completable completable3 = Completable.fromCallable(MessagePreviewEngine::handleMessagePreviewEvent$lambda$1);
                    Intrinsics.checkNotNull((Object)completable3);
                    completable = completable3;
                    break;
                }
                default: {
                    Completable completable4 = Completable.complete();
                    Intrinsics.checkNotNull((Object)completable4);
                    completable = completable4;
                    break;
                }
            }
        } else if (this.isActive && this.messagePreviewSetting != AmityMessagePreviewSetting.NO_MESSAGE_PREVIEW) {
            MessagePreviewEvent messagePreviewEvent = event;
            if (messagePreviewEvent instanceof MessagePreviewEvent.MessageCreated) {
                completable = this.handleMessageCreatedEvent((MessagePreviewEvent.MessageCreated)event);
            } else if (messagePreviewEvent instanceof MessagePreviewEvent.MessageUpdated) {
                completable = this.handleMessageUpdated((MessagePreviewEvent.MessageUpdated)event);
            } else if (messagePreviewEvent instanceof MessagePreviewEvent.MessageDeleted) {
                completable = this.handleMessageDeleted((MessagePreviewEvent.MessageDeleted)event);
            } else if (messagePreviewEvent instanceof MessagePreviewEvent.SubChannelUpdated) {
                completable = this.handleSubChannelUpdated((MessagePreviewEvent.SubChannelUpdated)event);
            } else if (messagePreviewEvent instanceof MessagePreviewEvent.SubChannelDeleted) {
                completable = this.handleSubChannelDeleted((MessagePreviewEvent.SubChannelDeleted)event);
            } else {
                Completable completable5 = Completable.complete();
                completable = completable5;
                Intrinsics.checkNotNullExpressionValue((Object)completable5, (String)"complete(...)");
            }
        } else {
            Completable completable6 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable6);
            completable = completable6;
        }
        return completable;
    }

    private final Completable handleMessageCreatedEvent(MessagePreviewEvent.MessageCreated event) {
        MessagePreviewEntity messagePreviewEntity;
        block3: {
            block2: {
                messagePreviewEntity = new MessageEventToMessagePreviewUseCase().execute(event);
                if (messagePreviewEntity == null) break block2;
                MessagePreviewEntity messagePreviewEntity2 = messagePreviewEntity;
                MessagePreviewSaveUseCase messagePreviewSaveUseCase = new MessagePreviewSaveUseCase();
                MessagePreviewEntity p0 = messagePreviewEntity2;
                boolean bl = false;
                Completable completable = messagePreviewSaveUseCase.execute(p0);
                messagePreviewEntity = completable;
                if (completable != null) break block3;
            }
            Completable completable = Completable.complete();
            messagePreviewEntity = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return messagePreviewEntity;
    }

    private final Completable handleMessageUpdated(MessagePreviewEvent.MessageUpdated event) {
        MessagePreviewEntity messagePreviewEntity;
        block3: {
            block2: {
                messagePreviewEntity = new MessageEventToMessagePreviewUseCase().execute(event);
                if (messagePreviewEntity == null) break block2;
                MessagePreviewEntity messagePreviewEntity2 = messagePreviewEntity;
                MessagePreviewUpdatedUseCase messagePreviewUpdatedUseCase = new MessagePreviewUpdatedUseCase();
                MessagePreviewEntity p0 = messagePreviewEntity2;
                boolean bl = false;
                Completable completable = messagePreviewUpdatedUseCase.execute(p0);
                messagePreviewEntity = completable;
                if (completable != null) break block3;
            }
            Completable completable = Completable.complete();
            messagePreviewEntity = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return messagePreviewEntity;
    }

    private final Completable handleMessageDeleted(MessagePreviewEvent.MessageDeleted event) {
        AmityMessagePreviewSetting amityMessagePreviewSetting;
        block8: {
            block7: {
                amityMessagePreviewSetting = this.messagePreviewSetting;
                if (amityMessagePreviewSetting == null) break block7;
                AmityMessagePreviewSetting setting = amityMessagePreviewSetting;
                boolean bl = false;
                Completable completable = switch (WhenMappings.$EnumSwitchMapping$0[setting.ordinal()]) {
                    case 3 -> this.handleMessageUpdated(new MessagePreviewEvent.MessageUpdated(event.getMessage(), event.getSubChannel()));
                    case 2 -> this.fetchSubChannelIfNeeded(event);
                    case 1 -> {
                        Completable var4_4 = Completable.complete();
                        Intrinsics.checkNotNull((Object)var4_4);
                        yield var4_4;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                amityMessagePreviewSetting = completable;
                if (completable != null) break block8;
            }
            Completable completable = Completable.complete();
            amityMessagePreviewSetting = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return amityMessagePreviewSetting;
    }

    private final Completable handleSubChannelUpdated(MessagePreviewEvent.SubChannelUpdated event) {
        Object object;
        block6: {
            block5: {
                Completable completable;
                MessagePreviewRepository messagePreviewRepository = new MessagePreviewRepository();
                object = event.getSubChannel().getSubChannelId();
                if (object == null) break block5;
                String p0 = object;
                boolean bl = false;
                MessagePreviewEntity messagePreviewEntity = messagePreviewRepository.getMessagePreviewBySubChannelId(p0);
                object = messagePreviewEntity;
                if (messagePreviewEntity == null) break block5;
                Object cache = object;
                boolean bl2 = false;
                DateTime dateTime = ((MessagePreviewEntity)cache).getSubChannelUpdatedAt();
                boolean bl3 = dateTime != null ? dateTime.isBefore((ReadableInstant)event.getSubChannel().getUpdatedAt()) : false;
                if (bl3 && event.getSubChannel().getName() != null) {
                    String string = event.getSubChannel().getSubChannelId();
                    String string2 = event.getSubChannel().getName();
                    DateTime dateTime2 = event.getSubChannel().getUpdatedAt();
                    Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"getUpdatedAt(...)");
                    completable = messagePreviewRepository.updateSubChannelInfo(string, string2, dateTime2).andThen((CompletableSource)Completable.fromAction(() -> MessagePreviewEngine.handleSubChannelUpdated$lambda$9$lambda$5(event)).onErrorComplete()).andThen((CompletableSource)Completable.fromAction(() -> MessagePreviewEngine.handleSubChannelUpdated$lambda$9$lambda$8(event, messagePreviewRepository)).onErrorComplete());
                } else {
                    completable = Completable.complete();
                }
                object = completable;
                if (completable != null) break block6;
            }
            Completable completable = Completable.complete();
            object = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return object;
    }

    private final Completable handleSubChannelDeleted(MessagePreviewEvent.SubChannelDeleted event) {
        AmityMessagePreviewSetting amityMessagePreviewSetting;
        block10: {
            block9: {
                Completable completable;
                amityMessagePreviewSetting = this.messagePreviewSetting;
                if (amityMessagePreviewSetting == null) break block9;
                AmityMessagePreviewSetting setting = amityMessagePreviewSetting;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[setting.ordinal()]) {
                    case 2: 
                    case 3: {
                        Object object = event.getSubChannel().getChannelPublicId();
                        if (object != null) {
                            String string = object;
                            MessagePreviewRepository messagePreviewRepository = new MessagePreviewRepository();
                            String p0 = string;
                            boolean bl2 = false;
                            MessagePreviewEntity messagePreviewEntity = messagePreviewRepository.getMessagePreviewByChannelId(p0);
                            object = messagePreviewEntity;
                            if (messagePreviewEntity != null) {
                                Object channelCache = object;
                                boolean bl3 = false;
                                if (Intrinsics.areEqual((Object)((MessagePreviewEntity)channelCache).getSubChannelId(), (Object)event.getSubChannel().getSubChannelId())) {
                                    completable = new ChannelRepository().fetchAndSave(event.getSubChannel().getChannelPublicId());
                                    break;
                                }
                                Completable completable2 = Completable.complete();
                                Intrinsics.checkNotNull((Object)completable2);
                                completable = completable2;
                                break;
                            }
                        }
                        completable = null;
                        break;
                    }
                    default: {
                        completable = Completable.complete();
                    }
                }
                amityMessagePreviewSetting = completable;
                if (completable != null) break block10;
            }
            Completable completable = Completable.complete();
            amityMessagePreviewSetting = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return amityMessagePreviewSetting;
    }

    private final Completable fetchSubChannelIfNeeded(MessagePreviewEvent.MessageDeleted event) {
        Completable completable;
        MessagePreviewRepository messagePreviewRepository = new MessagePreviewRepository();
        String string = event.getMessage().getMessageId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessageId(...)");
        AmityMessagePreview cache = messagePreviewRepository.getMessagePreview(string);
        if (cache != null) {
            Completable completable2;
            String string2 = event.getMessage().getChannelId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getChannelId(...)");
            MessagePreviewEntity channelCache = messagePreviewRepository.getMessagePreviewByChannelId(string2);
            String string3 = event.getMessage().getMessageId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessageId(...)");
            messagePreviewRepository.deleteMessagePreview(string3);
            SubChannelRepository subChannelRepository = new SubChannelRepository();
            String string4 = event.getMessage().getSubChannelId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSubChannelId(...)");
            Completable completable3 = subChannelRepository.fetchAndSave(string4).onErrorComplete();
            MessagePreviewEntity messagePreviewEntity = channelCache;
            if (Intrinsics.areEqual((Object)(messagePreviewEntity != null ? messagePreviewEntity.getMessagePreviewId() : null), (Object)event.getMessage().getMessageId())) {
                ChannelRepository channelRepository = new ChannelRepository();
                String string5 = event.getMessage().getChannelId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getChannelId(...)");
                completable2 = channelRepository.fetchAndSave(string5).onErrorComplete();
            } else {
                completable2 = Completable.complete();
            }
            Completable completable4 = completable3.andThen((CompletableSource)completable2);
            Intrinsics.checkNotNull((Object)completable4);
            completable = completable4;
        } else {
            Completable completable5 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable5);
            completable = completable5;
        }
        return completable;
    }

    private final void fetchChatSettings() {
        new GetChatSettingsUseCase().execute().distinctUntilChanged().doOnNext(new Consumer(this){
            final /* synthetic */ MessagePreviewEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(AmityChatSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MessagePreviewEngine.access$setMessagePreviewSetting$p(this.this$0, it.messagePreviewSetting());
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.isActive = true;
            Disposable disposable = new GetChatSettingsUseCase().execute().distinctUntilChanged().doOnNext(new Consumer(this){
                final /* synthetic */ MessagePreviewEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(AmityChatSettings it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MessagePreviewEngine.access$setMessagePreviewSetting$p(this.this$0, it.messagePreviewSetting());
                }
            }).subscribeOn(Schedulers.io()).subscribe();
            Intrinsics.checkNotNull((Object)disposable);
        } else {
            this.isActive = false;
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isActive = true;
        this.fetchChatSettings();
    }

    @Override
    public void destroy() {
        this.isActive = false;
    }

    @Override
    public void handleTokenExpire() {
        this.isActive = false;
    }

    private static final Unit handleMessagePreviewEvent$lambda$0() {
        new MessagePreviewRepository().clearAllMessagePreviews();
        return Unit.INSTANCE;
    }

    private static final Unit handleMessagePreviewEvent$lambda$1() {
        new MessagePreviewRepository().clearDeletedMessagePreviews();
        return Unit.INSTANCE;
    }

    private static final void handleSubChannelUpdated$lambda$9$lambda$5(MessagePreviewEvent.SubChannelUpdated $event) {
        new SubChannelRepository().notifyChanges$amity_sdk_release($event.getSubChannel().getSubChannelId());
    }

    private static final void handleSubChannelUpdated$lambda$9$lambda$8(MessagePreviewEvent.SubChannelUpdated $event, MessagePreviewRepository $messagePreviewRepository) {
        block3: {
            Object object = $event.getSubChannel().getChannelPublicId();
            if (object == null) break block3;
            String p0 = object;
            boolean bl = false;
            MessagePreviewEntity messagePreviewEntity = $messagePreviewRepository.getMessagePreviewByChannelId(p0);
            object = messagePreviewEntity;
            if (messagePreviewEntity != null) {
                Object channelCache = object;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)((MessagePreviewEntity)channelCache).getSubChannelId(), (Object)$event.getSubChannel().getSubChannelId())) {
                    new ChannelRepository().notifyChanges$amity_sdk_release($event.getSubChannel().getChannelPublicId());
                } else {
                    Completable.complete();
                }
            }
        }
    }

    public static final /* synthetic */ void access$setMessagePreviewSetting$p(MessagePreviewEngine $this, AmityMessagePreviewSetting amityMessagePreviewSetting) {
        $this.messagePreviewSetting = amityMessagePreviewSetting;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityMessagePreviewSetting.values().length];
            try {
                nArray[AmityMessagePreviewSetting.NO_MESSAGE_PREVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityMessagePreviewSetting.MESSAGE_PREVIEW_NOT_INCLUDE_DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityMessagePreviewSetting.MESSAGE_PREVIEW_INCLUDE_DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

