package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable

internal class LiveRoomPostQueryUseCase {

    fun execute(targetType: String, targetIds: List<String>): Flowable<List<AmityPost>> {
        val postRepository = PostRepository()
        val postComposerUseCase = PostComposerUseCase()

        return postRepository.getLiveRoomPosts(targetType, targetIds)
            .switchMap { posts ->
                val livePosts = posts
                    .map(postComposerUseCase::execute)
                    .mapNotNull { post ->
                        val roomData = post.data as? AmityPost.Data.ROOM
                        val room = roomData?.room
                        if (room != null && room.getStatus() == AmityRoomStatus.LIVE) {
                            post
                        } else {
                            null
                        }
                    }

                Flowable.just(livePosts)
            }

    }

}
