package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembership
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles

internal const val CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME = "channel_membership_query_token"

@Entity(
    tableName = CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME,
    primaryKeys = ["channelId", "roles", "filter", "sortBy", "pageNumber"]
)
class EkoChannelMembershipQueryToken : EkoQueryToken() {
    var channelId: String = ""
    var roles: AmityRoles = AmityRoles()
    var filter: AmityChannelMembershipFilter = AmityChannelMembershipFilter.ALL
    var sortBy: String = AmityChannelMembershipSortOption.LAST_CREATED.apiKey
}