package com.ekoapp.ekosdk.internal.api.dto

import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

data class EventDto(
    @SerializedName("publicId")
    val publicId: String? = null,
    
    @SerializedName("eventId")
    val eventId: String? = null,
    
    @SerializedName("title")
    val title: String? = null,
    
    @SerializedName("description")
    val description: String? = null,
    
    @SerializedName("type")
    val type: String? = null,
    
    @SerializedName("status")
    val status: String? = null,
    
    @SerializedName("startTime")
    val startTime: DateTime? = null,
    
    @SerializedName("endTime")
    val endTime: DateTime? = null,
    
    @SerializedName("coverImageFileId")
    val coverImageFileId: String? = null,
    
    @SerializedName("originType")
    val originType: String? = null,
    
    @SerializedName("originId")
    val originId: String? = null,
    
    @SerializedName("livestreamId")
    val livestreamId: String? = null,
    
    @SerializedName("userId")
    val userId: String? = null,
    
    @SerializedName("discussionCommunityId")
    val discussionCommunityId: String? = null,
    
    @SerializedName("postId")
    val postId: String? = null,
    
    @SerializedName("rsvpCount")
    val rsvpCount: Int? = null,
    
    @SerializedName("interestedCount")
    val interestedCount: Int? = null,
    
    @SerializedName("isLocationVisible")
    val isLocationVisible: Boolean? = null,
    
    @SerializedName("location")
    val location: String? = null,
    
    @SerializedName("metadata")
    val metadata: JsonObject? = null,
    
    @SerializedName("createdAt")
    val createdAt: DateTime? = null,
    
    @SerializedName("updatedAt")
    val updatedAt: DateTime? = null,
    
    @SerializedName("path")
    val path: String? = null
)
