package com.amity.socialcloud.sdk.video.data.room

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import co.amity.rxremotemediator.AmityPagingDao.Sorting
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.keycreator.RoomKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface RoomPagingDao : DynamicQueryStreamPagingDao<RoomEntity> {

    @RawQuery(observedEntities = [RoomEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, RoomEntity>

    fun queryRoomList(
        statuses: List<String>,
        types: List<String>?,
        isDeleted: Boolean?,
        sortBy: String?
    ): PagingSource<Int, RoomEntity> {
        val sortColumns = when (sortBy) {
            "firstCreated" -> listOf(Sorting.Column("room", "createdAt", AmityPagingDao.Order.ASC))
            "lastCreated" -> listOf(Sorting.Column("room", "createdAt", AmityPagingDao.Order.DESC))
            else -> emptyList()
        }
        return queryPagingData(
            if (sortColumns.isEmpty()) {
                generateQueryStreamSQL(
                    tableName = "room",
                    primaryKeyColumnName = "roomId",
                    dynamicQueryStreamKeyCreator = RoomKeyCreator(statuses, types, isDeleted, sortBy),
                    nonce = AmityNonce.ROOM_LIST,
                    order = AmityPagingDao.Order.ASC
                )
            } else {
                generateQueryStreamSQL(
                    tableName = "room",
                    primaryKeyColumnName = "roomId",
                    dynamicQueryStreamKeyCreator = RoomKeyCreator(statuses, types, isDeleted, sortBy),
                    nonce = AmityNonce.ROOM_LIST,
                    order = AmityPagingDao.Order.ASC,
                    sortColumns = sortColumns
                )
            }
        )
    }
}
