package com.amity.socialcloud.sdk.social.domain.post

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import io.reactivex.Observable
import io.reactivex.Single
import io.reactivex.schedulers.Schedulers

internal class PostsGetUseCase {

    fun execute(postIds: List<String>): List<AmityPost> {
        return Single.fromCallable {
            PostRepository().getPosts(postIds)
        }.flattenAsObservable { it }
            .flatMap {
                Observable.fromCallable {
                    PostComposerUseCase().execute(it)
                }.subscribeOn(Schedulers.io())
            }
            .toList()
            .blockingGet()
            .let{ posts ->
                val orderById = postIds.withIndex().associate { it.value to it.index }
                val sortedPost = posts.sortedBy { orderById[it.getPostId()] }
                sortedPost
            }
    }
}