package com.amity.socialcloud.sdk.entity.video.stream

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import org.amity.types.ObjectId

@Entity(tableName = "stream")
open class EkoStreamEntity : EkoObject() {

    @PrimaryKey
    var streamId: String = ObjectId.get().toHexString()
    var moderationId: String = ""
    var title: String? = null
    var description: String? = null
    var metadata: JsonObject? = null
    var isDeleted: Boolean = false
    var thumbnailFileId: String? = null
    var userId: String? = null
    var watcherData: JsonObject? = null
    var broadcasterData: JsonObject? = null
    var recordings: JsonArray? = null
    var status: String? = null
    var isReconnecting: Boolean = false
    var resolution: String? = null
    var referenceId: String? = null
    var referenceType: String? = null
    var targetId: String? = null
    var targetType: String? = null
    var postId: String? = null
    var channelId: String? = null
    var channelEnabled: Boolean? = null
    var isBanned: Boolean? = null
    var isParent: Boolean? = null
    var parentStreamId: String? = null
    var childStreamIds: List<String>? = null

    override fun getId(): String {
        return streamId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? EkoStreamEntity)?.let { stream ->
            (Objects.equal(streamId, stream.streamId)
                && Objects.equal(moderationId, stream.moderationId)
                && Objects.equal(title, stream.title)
                && Objects.equal(isReconnecting, stream.isReconnecting)
                && Objects.equal(description, stream.description)
                && Objects.equal(thumbnailFileId, stream.thumbnailFileId)
                && Objects.equal(userId, stream.userId)
                && Objects.equal(metadata, stream.metadata)
                && Objects.equal(watcherData, stream.watcherData)
                && Objects.equal(broadcasterData, stream.broadcasterData)
                && Objects.equal(recordings, stream.recordings)
                && Objects.equal(status, stream.status)
                && Objects.equal(isDeleted, stream.isDeleted)
                && Objects.equal(resolution, stream.resolution)
                && Objects.equal(referenceId, stream.referenceId)
                && Objects.equal(referenceType, stream.referenceType)
                && Objects.equal(targetId, stream.targetId)
                && Objects.equal(targetType, stream.targetType)
                && Objects.equal(postId, stream.postId)
                && Objects.equal(channelId, stream.channelId)
                && Objects.equal(channelEnabled, stream.channelEnabled)
                && Objects.equal(isBanned, stream.isBanned)
            )
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            streamId,
            moderationId,
            isReconnecting,
            title,
            description,
            metadata,
            thumbnailFileId,
            userId,
            watcherData,
            broadcasterData,
            recordings,
            status,
            resolution,
            referenceId,
            referenceType,
            targetId,
            targetType,
            postId,
            channelId,
            channelEnabled,
            isDeleted,
            isBanned
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("streamId", streamId)
            add("moderationId", moderationId)
            add("isReconnecting", isReconnecting)
            add("title", title)
            add("description", description)
            add("metadata", metadata)
            add("watcherData", watcherData)
            add("broadcasterData", broadcasterData)
            add("recordings", recordings)
            add("thumbnailFileId", thumbnailFileId)
            add("userId", userId)
            add("status", status)
            add("resolution", resolution)
            add("isDeleted", isDeleted)
            add("refId", referenceId)
            add("refType", referenceType)
            add("targetId", targetId)
            add("targetType", targetType)
            add("postId", postId)
            add("channelId", channelId)
            add("channelEnabled", channelEnabled)
            add("isBanned", isBanned)
            add("isParent", isParent)
            add("parentStreamId", parentStreamId)
            add("childStreamIds", childStreamIds?.joinToString(","))
        }
        return super.internalToString(toStringHelper)
    }
}