package com.amity.socialcloud.sdk.chat.data.subchannel

import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.SubChannelCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.SubChannelUpdateRequest
import io.reactivex.rxjava3.core.Single

internal class SubChannelRemoteDataStore {

    fun fetchSubChannel(subChannelId: String): Single<SubChannelListDto> {
        return AmityHttpClient.get(SubChannelApi::class).flatMap {
            it.getSubChannel(subChannelId)
        }
    }

    fun createSubChannel(channelId: String, name: String): Single<SubChannelListDto> {
        val request = SubChannelCreateRequest(
            channelId = channelId,
            name = name
        )
        return AmityHttpClient.get(SubChannelApi::class).flatMap {
            it.createSubChannel(request)
        }
    }

    fun updateSubChannel(subChannelId: String, name: String): Single<SubChannelListDto> {
        val request = SubChannelUpdateRequest(name = name)
        return AmityHttpClient.get(SubChannelApi::class).flatMap {
            it.updateSubChannel(subChannelId, request)
        }
    }

    fun deleteSubChannel(subChannelId: String, hardDelete: Boolean): Single<SubChannelListDto> {
        return AmityHttpClient.get(SubChannelApi::class).flatMap {
            it.deleteSubChannel(subChannelId, hardDelete)
        }
    }

    fun querySubChannels(
        internalChannelId: String,
        excludeMainSubChannel: Boolean,
        isDeleted: Boolean? = null,
        options: QueryOptionsRequestParams
    ): Single<SubChannelQueryDto> {
        return AmityHttpClient.get(SubChannelApi::class).flatMap {
            it.querySubChannels(
                channelId = internalChannelId,
                isDeleted = isDeleted,
                excludeDefaultMessageFeed = excludeMainSubChannel,
                limit = options.limit,
                token = options.token
            )
        }
    }
}