/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.room;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.room.RoomLocalDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomMediator;
import com.amity.socialcloud.sdk.core.data.room.RoomModerationLocalDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomQueryPersister;
import com.amity.socialcloud.sdk.core.data.room.RoomRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomRepository;
import com.amity.socialcloud.sdk.dto.video.EkoRoomBroadcastDataDto;
import com.amity.socialcloud.sdk.dto.video.EkoRoomDto;
import com.amity.socialcloud.sdk.dto.video.EkoRoomListDto;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity;
import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomModeration;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomSortOption;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType;
import com.amity.socialcloud.sdk.video.data.room.RoomModelMapper;
import com.amity.socialcloud.sdk.video.data.room.RoomModerationModelMapper;
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.socket.request.CreateRoomRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UpdateRoomRequest;
import com.ekoapp.ekosdk.internal.keycreator.RoomKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\bJY\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\n2\u0006\u0010\u0019\u001a\u00020\u0007J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001a\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\n2\u0006\u0010\u0019\u001a\u00020\u0007JK\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0*0&2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u00112\b\u0010,\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0019\u001a\u00020\u0007J\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020'0\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020\u0007J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0019\u001a\u00020\u0007JK\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u00106\u00a8\u00067"}, d2={"Lcom/amity/socialcloud/sdk/core/data/room/RoomRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "buildQueryToken", "Lcom/ekoapp/ekosdk/internal/token/DynamicQueryStreamQueryToken;", "statuses", "", "", "buildQueryToken$amity_sdk_release", "createRoom", "Lio/reactivex/rxjava3/core/Single;", "title", "description", "thumbnailFileId", "metadata", "Lcom/google/gson/JsonObject;", "channelEnabled", "", "parentRoomId", "participants", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;Ljava/lang/String;Ljava/util/List;)Lio/reactivex/rxjava3/core/Single;", "defaultPageSize", "", "deleteRoom", "Lio/reactivex/rxjava3/core/Completable;", "roomId", "fetchRoom", "formatStatuses", "", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;)Ljava/util/List;", "formatTypes", "types", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;)Ljava/util/List;", "getBroadcasterData", "Lcom/amity/socialcloud/sdk/dto/video/EkoRoomBroadcastDataDto;", "getLatestRoom", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "getRecordedUrls", "getRoomCollectionPagingData", "Landroidx/paging/PagingData;", "isDeleted", "sortBy", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomSortOption;", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;[Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomSortOption;)Lio/reactivex/rxjava3/core/Flowable;", "getRoomModerationByRoom", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomModeration;", "getRoomsByIds", "roomIds", "observeRoom", "stopRoom", "updateRoom", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nRoomRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomRepository.kt\ncom/amity/socialcloud/sdk/core/data/room/RoomRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n1549#2:165\n1620#2,3:166\n1#3:169\n11335#4:170\n11670#4,3:171\n11335#4:174\n11670#4,3:175\n*S KotlinDebug\n*F\n+ 1 RoomRepository.kt\ncom/amity/socialcloud/sdk/core/data/room/RoomRepository\n*L\n71#1:161\n71#1:162,3\n72#1:165\n72#1:166,3\n151#1:170\n151#1:171,3\n154#1:174\n154#1:175,3\n*E\n"})
public final class RoomRepository
extends EkoObjectRepository {
    private final int defaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityRoom>> getRoomCollectionPagingData(@Nullable AmityRoomStatus[] statuses, @Nullable AmityRoomType[] types, @Nullable Boolean isDeleted, @Nullable AmityRoomSortOption sortBy) {
        List<String> statusList = this.formatStatuses(statuses);
        List<String> typeList = this.formatTypes(types);
        AmityRoomSortOption amityRoomSortOption = sortBy;
        String sortKey = amityRoomSortOption != null ? amityRoomSortOption.getApiKey() : null;
        RoomMediator mediator = new RoomMediator(statusList, typeList, isDeleted, sortKey);
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.defaultPageSize(), 0, false, 0, 0, 0, 58, null), null, mediator, (Function0)new Function0<PagingSource<Integer, RoomEntity>>(statusList, typeList, isDeleted, sortKey){
            final /* synthetic */ List<String> $statusList;
            final /* synthetic */ List<String> $typeList;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ String $sortKey;
            {
                this.$statusList = $statusList;
                this.$typeList = $typeList;
                this.$isDeleted = $isDeleted;
                this.$sortKey = $sortKey;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, RoomEntity> invoke() {
                return new RoomLocalDataStore().getRoomsPagingSource(this.$statusList, this.$typeList, this.$isDeleted, this.$sortKey);
            }
        }, (ModelMapper)new RoomModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityRoom> observeRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        Flowable flowable = new RoomLocalDataStore().observeRoom(roomId).map(new Function(roomModelMapper){
            final /* synthetic */ RoomModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final AmityRoom apply(@NotNull RoomEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        }).map((Function)observeRoom.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"RoomLocalDataStore().obs\u2026erUseCase().execute(it) }");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AmityRoom> getRoomsByIds(@NotNull List<String> roomIds) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(roomIds, (String)"roomIds");
        Iterable iterable = new RoomLocalDataStore().getRoomsByIds(roomIds);
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        boolean $i$f$map22 = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            RoomEntity roomEntity = (RoomEntity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(roomModelMapper.map((RoomEntity)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (AmityRoom)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new RoomComposerUseCase().execute((AmityRoom)it));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final Completable fetchRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Completable completable = new RoomRemoteDataStore().getRoom(roomId).flatMapCompletable((Function)fetchRoom.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"RoomRemoteDataStore().ge\u2026Persister().persist(it) }");
        return completable;
    }

    @NotNull
    public final Single<String> createRoom(@NotNull String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean channelEnabled, @Nullable String parentRoomId, @NotNull List<String> participants) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        CreateRoomRequest request = new CreateRoomRequest(title, description, thumbnailFileId, metadata, channelEnabled, parentRoomId, null, participants, 64, null);
        Single single = new RoomRemoteDataStore().createRoom(request).flatMap((Function)createRoom.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"RoomRemoteDataStore().cr\u2026mId ?: \"\"))\n            }");
        return single;
    }

    @NotNull
    public final Single<String> updateRoom(@NotNull String roomId, @Nullable String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean channelEnabled) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        UpdateRoomRequest request = new UpdateRoomRequest(title, description, thumbnailFileId, metadata, channelEnabled, null, 32, null);
        Single single = new RoomRemoteDataStore().updateRoom(roomId, request).flatMap(new Function(roomId){
            final /* synthetic */ String $roomId;
            {
                this.$roomId = $roomId;
            }

            @NotNull
            public final SingleSource<? extends String> apply(@NotNull EkoRoomListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Completable completable = new RoomQueryPersister().persist(dto);
                List<EkoRoomDto> list2 = dto.getRooms();
                if (list2 == null || (list2 = (EkoRoomDto)CollectionsKt.firstOrNull(list2)) == null || (list2 = ((EkoRoomDto)((Object)list2)).getRoomId()) == null) {
                    list2 = this.$roomId;
                }
                return (SingleSource)completable.andThen((SingleSource)Single.just((Object)list2));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"roomId: String,\n        \u2026?: roomId))\n            }");
        return single;
    }

    @NotNull
    public final Completable deleteRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Completable completable = new RoomRemoteDataStore().deleteRoom(roomId).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"RoomRemoteDataStore().de\u2026m(roomId).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Single<String> stopRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Single single = new RoomRemoteDataStore().stopRoom(roomId).flatMap(new Function(roomId){
            final /* synthetic */ String $roomId;
            {
                this.$roomId = $roomId;
            }

            @NotNull
            public final SingleSource<? extends String> apply(@NotNull EkoRoomListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Completable completable = new RoomQueryPersister().persist(dto);
                List<EkoRoomDto> list2 = dto.getRooms();
                if (list2 == null || (list2 = (EkoRoomDto)CollectionsKt.firstOrNull(list2)) == null || (list2 = ((EkoRoomDto)((Object)list2)).getRoomId()) == null) {
                    list2 = this.$roomId;
                }
                return (SingleSource)completable.andThen((SingleSource)Single.just((Object)list2));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"roomId: String): Single<\u2026?: roomId))\n            }");
        return single;
    }

    @NotNull
    public final Single<List<String>> getRecordedUrls(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Single single = new RoomRemoteDataStore().getRoomRecordedUrls(roomId).map((Function)getRecordedUrls.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"RoomRemoteDataStore().ge\u2026rdedUrls ?: emptyList() }");
        return single;
    }

    @NotNull
    public final Single<EkoRoomBroadcastDataDto> getBroadcasterData(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new RoomRemoteDataStore().getBroadcasterData(roomId);
    }

    @NotNull
    public final Flowable<AmityRoom> getLatestRoom(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        Flowable flowable = new RoomLocalDataStore().getLatestRoom(statuses).map(new Function(roomModelMapper){
            final /* synthetic */ RoomModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final AmityRoom apply(@NotNull RoomEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        }).map((Function)getLatestRoom.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"RoomLocalDataStore().get\u2026erUseCase().execute(it) }");
        return flowable;
    }

    @Nullable
    public final AmityRoomModeration getRoomModerationByRoom(@NotNull String roomId) {
        AmityRoomModeration amityRoomModeration;
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        RoomModerationEntity roomModerationEntity = new RoomModerationLocalDataStore().getModerationByRoomId(roomId);
        if (roomModerationEntity != null) {
            RoomModerationEntity it = roomModerationEntity;
            boolean bl = false;
            amityRoomModeration = new RoomModerationModelMapper().map(it);
        } else {
            amityRoomModeration = null;
        }
        return amityRoomModeration;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> formatStatuses(AmityRoomStatus[] statuses) {
        void $this$mapTo$iv$iv;
        AmityRoomStatus[] it;
        Object object;
        block5: {
            AmityRoomStatus[] amityRoomStatusArray;
            block4: {
                object = statuses;
                if (statuses == null) break block4;
                it = amityRoomStatusArray = object;
                boolean bl = false;
                object = !(it.length == 0) ? amityRoomStatusArray : null;
                if (object != null) break block5;
            }
            amityRoomStatusArray = new AmityRoomStatus[]{AmityRoomStatus.IDLE};
            object = amityRoomStatusArray;
        }
        AmityRoomStatus[] $this$map$iv = object;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getApiKey());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<String> formatTypes(AmityRoomType[] types) {
        void $this$mapTo$iv$iv;
        AmityRoomType[] amityRoomTypeArray;
        AmityRoomType[] amityRoomTypeArray2 = types;
        if (types == null) return null;
        AmityRoomType[] it = amityRoomTypeArray = amityRoomTypeArray2;
        boolean $i$a$-takeIf-RoomRepository$formatTypes$22 = false;
        if (it.length == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        AmityRoomType[] amityRoomTypeArray2 = amityRoomTypeArray;
        amityRoomTypeArray2 = amityRoomTypeArray2;
        if (amityRoomTypeArray3 == null) return null;
        AmityRoomType[] $this$map$iv = amityRoomTypeArray2;
        boolean $i$f$map = false;
        AmityRoomType[] $i$a$-takeIf-RoomRepository$formatTypes$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it2.getApiKey());
        }
        List list2 = (List)destination$iv$iv;
        return list2;
    }

    @NotNull
    public final DynamicQueryStreamQueryToken buildQueryToken$amity_sdk_release(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return new DynamicQueryStreamQueryToken(new RoomKeyCreator(statuses, null, null, null), null, null, (List<String>)CollectionsKt.emptyList());
    }
}

