package com.ekoapp.ekosdk.internal.data.model;

import static com.ekoapp.ekosdk.internal.util.EkoPreconditions.checkValidId;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;


@Entity(tableName = "mqtt_url")
public class EkoMqttUrl {

    private static final String SINGLETON_MQTT_URL_ID = "SINGLETON_MQTT_URL_ID";

    @PrimaryKey
    @NonNull
    private String id = currentMqttUrlId();
    private String mqttUrl;
    private long updateAt = System.currentTimeMillis();


    public static String currentMqttUrlId() {
        return SINGLETON_MQTT_URL_ID;
    }

    @NonNull
    public String getId() {
        return currentMqttUrlId();
    }

    public void setId(String id) {
        // NO OP
        this.id = currentMqttUrlId();
    }

    @NonNull
    public String getMqttUrl() {
        return mqttUrl;
    }

    public void setMqttUrl(@NonNull String httpUrl) {
        this.mqttUrl = checkValidId(httpUrl, "mqttUrl");
    }

    public long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoMqttUrl create(@NonNull String url) {
        EkoMqttUrl urlStore = new EkoMqttUrl();
        urlStore.setMqttUrl(url);
        return urlStore;
    }
}
