package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class SemanticSearchPostKeyCreator(
    private val query: String,
    private val targetType: String?,
    private val targetId: String?,
    private val postTypes: List<AmityPost.DataType>,
    private val matchingOnlyParentPosts: Boolean,
    ) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "query" to query,
            "targetId" to (targetId ?: "null"),
            "targetType" to (targetType ?: "null"),
            "matchingOnlyParentPost" to matchingOnlyParentPosts,
            "postTypes" to PostRepositoryHelper.convertPostTypesToString(postTypes)
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            targetType = targetType,
            targetId = targetId,
            matchingOnlyParentPost = matchingOnlyParentPosts,
            postTypes = postTypes
        )
    }

    private fun getConditionStatement(
        targetType: String?,
        targetId: String?,
        matchingOnlyParentPost: Boolean,
        postTypes: List<AmityPost.DataType>
    ): String {
        val isDeletedFilterStatement = "post.isDeleted = 0"
        return isDeletedFilterStatement
    }

}