package com.amity.socialcloud.sdk.social.data.poll

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.dao.PollDao
import com.ekoapp.ekosdk.internal.entity.PollEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class PollLocalDataStore {

    fun savePolls(polls: List<PollEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().pollDao().save(polls) }
    }

    fun observePoll(pollId: String): Flowable<PollEntity> {
        val database = UserDatabase.get()
        val pollDao: PollDao = database.pollDao()
        return pollDao.getPoll(pollId)
    }

    fun deletePoll(pollId: String): Completable {
        return UserDatabase.get().pollDao().deletePoll(pollId)
    }
}