package com.amity.socialcloud.sdk.core.data.invitation

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationStatus
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.dao.InvitationDao
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity
import io.reactivex.rxjava3.core.Completable

internal class InvitationLocalDataStore {

    fun saveInvitations(
        reactions: List<InvitationEntity>
    ): Completable {
        return Completable.fromAction {
            val invitationDao: InvitationDao = UserDatabase.get().invitationDao()
            invitationDao.save(reactions)
        }
    }

    fun getInvitationsPagingSource(
        type: AmityInvitationType,
        target: InvitationMediator.Target
    ): PagingSource<Int, InvitationEntity> {
        return UserDatabase.get().invitationPagingDao().getInvitationPagingSource(type, target)
    }

    fun getInvitation(
        targetId: String,
    ): InvitationEntity? {
        return UserDatabase.get().invitationDao().getInvitation(targetId)
    }

    fun updateStatus(
        invitationId: String,
        status: AmityInvitationStatus
    ) {
        UserDatabase.get().invitationDao().updateStatus(invitationId, status.value)
    }

}