package com.amity.socialcloud.sdk.chat.domain.subchannel

import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.ekoapp.ekosdk.internal.SubChannelEntity
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class SubChannelLiveObjectUseCase :
    LiveObjectUseCase<SubChannelEntity, AmitySubChannel>() {

    override fun createRepository(): AmityObjectRepository<SubChannelEntity, AmitySubChannel> =
        SubChannelRepository()

    override fun composeModel(model: AmitySubChannel): AmitySubChannel = SubChannelComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.SUB_CHANNEL
}