package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerDto
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerDto
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerQueryDto
import io.reactivex.rxjava3.core.Completable

internal class SubChannelUnreadInfoQueryPersister : QueryPersister<UserSubChannelMarkerQueryDto>() {

    override fun persist(dto: UserSubChannelMarkerQueryDto): Completable {
        val subChannelUnreadInfoDto = mutableListOf<Pair<SubChannelMarkerDto, UserSubChannelMarkerDto>>()
        dto.userSubChannelMarkers.map {
            val subChannelMarkerDto = dto.subChannelMarkers.find { subChannelMarker -> subChannelMarker.subChannelId == it.subChannelId }
            if (subChannelMarkerDto != null && !subChannelMarkerDto.isDeleted) {
                subChannelUnreadInfoDto.add(Pair(subChannelMarkerDto, it))
            } else if (subChannelMarkerDto?.isDeleted == true) {
                // Delete unread info of deleted sub channel
                SubChannelMarkerRepository().deleteUnreadInfoBySubChannelId(subChannelMarkerDto.subChannelId)
            } else {
                // Skip this sub channel
            }
        }
        return Completable.fromAction {
            SubChannelMarkerRepository()
                .saveSubChannelUnreadInfo(
                    SubChannelUnreadInfoEntityMapper().map(subChannelUnreadInfoDto)
                )
        }
            .andThen(Completable.fromCallable {
                dto.subChannelMarkers
                    .map { it.channelId }
                    .let(ChannelRepository()::notifyChannelsChanges)
            })
    }
}