/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.room;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\bJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007JI\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/core/data/room/RoomLocalDataStore;", "", "()V", "getLatestRoom", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/entity/video/room/RoomEntity;", "statuses", "", "", "getRoom", "roomId", "getRoomsByIds", "roomIds", "getRoomsPagingSource", "Landroidx/paging/PagingSource;", "", "types", "isDeleted", "", "sortBy", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/String;)Landroidx/paging/PagingSource;", "notifyChanges", "", "observeRoom", "saveRooms", "Lio/reactivex/rxjava3/core/Completable;", "rooms", "amity-sdk_release"})
public final class RoomLocalDataStore {
    @NotNull
    public final Completable saveRooms(@NotNull List<? extends RoomEntity> rooms) {
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Completable completable = Completable.fromAction(() -> RoomLocalDataStore.saveRooms$lambda$0(rooms));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { if (rooms.i\u2026).roomDao().save(rooms) }");
        return completable;
    }

    @Nullable
    public final RoomEntity getRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Ref.ObjectRef entity = new Ref.ObjectRef();
        Completable.fromAction(() -> RoomLocalDataStore.getRoom$lambda$1(entity, roomId)).subscribeOn(Schedulers.io()).blockingAwait();
        return (RoomEntity)entity.element;
    }

    @NotNull
    public final Flowable<RoomEntity> observeRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return UserDatabase.get().roomDao().getById(roomId);
    }

    @NotNull
    public final List<RoomEntity> getRoomsByIds(@NotNull List<String> roomIds) {
        Intrinsics.checkNotNullParameter(roomIds, (String)"roomIds");
        return UserDatabase.get().roomDao().getByIdsNow(roomIds);
    }

    @NotNull
    public final PagingSource<Integer, RoomEntity> getRoomsPagingSource(@NotNull List<String> statuses, @Nullable List<String> types, @Nullable Boolean isDeleted, @Nullable String sortBy) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().roomPagingDao().queryRoomList(statuses, types, isDeleted, sortBy);
    }

    @NotNull
    public final Flowable<RoomEntity> getLatestRoom(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().roomDao().getLatestRoom(statuses);
    }

    public final void notifyChanges(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        UserDatabase.get().roomDao().updateRoom(roomId);
    }

    private static final void saveRooms$lambda$0(List $rooms) {
        Intrinsics.checkNotNullParameter((Object)$rooms, (String)"$rooms");
        if (!((Collection)$rooms).isEmpty()) {
            UserDatabase.get().roomDao().save($rooms);
        }
    }

    private static final void getRoom$lambda$1(Ref.ObjectRef $entity, String $roomId) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)$roomId, (String)"$roomId");
        $entity.element = UserDatabase.get().roomDao().getByIdNow($roomId);
    }
}

