package com.amity.socialcloud.sdk.entity.video.room

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.gson.JsonObject
import org.joda.time.DateTime
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "room")
open class RoomEntity : EkoObject() {
    @PrimaryKey
    var roomId: String = ObjectId.get().toHexString()
    var type: String? = null
    var targetType: String? = null
    var targetId: String? = null
    var referenceType: String? = null
    var referenceId: String? = null
    var channelEnabled: Boolean = false
    var channelId: String? = null
    var title: String? = null
    var description: String? = null
    var thumbnailFileId: String? = null
    var status: String? = null
    var participants: List<String>? = null // store userIds only for now
    var livePlaybackUrl: String? = null
    var durationSeconds: Int? = null
    var parentRoomId: String? = null
    var childRoomIds: List<String>? = null
    var creatorId: String? = null
    var isDeleted: Boolean = false
    var deletedAt: DateTime? = null
    var deletedById: String? = null
    var metadata: JsonObject? = null
    var liveAt: DateTime? = null
    var endedAt: DateTime? = null
    var recordedAt: DateTime? = null

    override fun getId(): String = roomId

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? RoomEntity)?.let { o ->
            Objects.equal(roomId, o.roomId) &&
                Objects.equal(status, o.status) &&
                Objects.equal(title, o.title) &&
                Objects.equal(description, o.description) &&
                Objects.equal(channelEnabled, o.channelEnabled) &&
                Objects.equal(channelId, o.channelId) &&
                Objects.equal(isDeleted, o.isDeleted)
        } ?: false
    }

    override fun hashCode(): Int {
        return Objects.hashCode(roomId, status, title, description, channelEnabled, channelId, isDeleted)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("roomId", roomId)
            add("status", status)
            add("title", title)
            add("isDeleted", isDeleted)
        }
        return super.internalToString(toStringHelper)
    }
}
