package com.amity.socialcloud.sdk.api.social.post.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityGlobalFeedQuery internal constructor(
    private val dataTypes: List<AmityPost.DataType>? = null
){

    /**
     * Queries for Global feed.
     * @return Flowable<PagingData<AmityPost>>.
     */
    fun query(): Flowable<PagingData<AmityPost>> {
        return GetGlobalFeedPagingDataUseCase().execute(
            dataTypes = dataTypes ?: listOf()
        )
    }

    class Builder internal constructor(){
        private var dataTypes: List<AmityPost.DataType> = listOf()

        /**
         * Specifies [dataTypes] to filter matching dataType.
         * @return the same AmityUserPostQuery.Builder instance.
         */
        fun dataTypes(dataTypes: List<AmityPost.DataType>): Builder {
            return apply { this.dataTypes = dataTypes }
        }

        /**
         * Instantiates AmityGlobalFeedQuery with built params.
         * @return new instance of AmityGlobalFeedQuery.
         */
        fun build(): AmityGlobalFeedQuery {
            return AmityGlobalFeedQuery(
                dataTypes = dataTypes
            )
        }
    }

}