package com.amity.socialcloud.sdk.social.domain.community

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequest
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequestStatus
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class CommunityGetJoinRequestQueryUseCase {
    fun execute(
        communityId: String,
        status: AmityJoinRequestStatus,
        sortBy: AmityCommunitySortOption? = null,
        targetType: String = "community",
        type: String = "communityJoinRequest",
    ): Flowable<PagingData<AmityJoinRequest>> {
        return CommunityRepository().getJoinRequestPagingData(
            communityId = communityId,
            status = status,
            sortBy = sortBy,
            targetType = targetType,
            type = type
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { member ->
                CommunityGetJoinRequestComposerUseCase().execute(member)
            }
        }
    }
}