package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.dto.video.EkoRoomQueryDto
import com.amity.socialcloud.sdk.dto.video.EkoRoomRecordedUrlsDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateRoomRequest
import com.ekoapp.ekosdk.internal.api.socket.request.UpdateRoomRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface RoomApi {
    // Create Room
    @POST("api/v1/rooms")
    fun createRoom(@Body request: CreateRoomRequest): Single<EkoRoomQueryDto>

    // Query Rooms
    @GET("api/v1/rooms")
    fun queryRooms(
        @Query("statuses[]") statuses: List<String>? = null,
        @Query("types[]") types: List<String>? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<EkoRoomQueryDto>

    // Get Room
    @GET("api/v1/rooms/{roomId}")
    fun getRoom(@Path("roomId") roomId: String): Single<EkoRoomQueryDto>

    // Update Room
    @PUT("api/v1/rooms/{roomId}")
    fun updateRoom(@Path("roomId") roomId: String, @Body request: UpdateRoomRequest): Single<EkoRoomQueryDto>

    // Delete Room (spec returns void, keep JsonObject placeholder like other APIs)
    @HTTP(method = "DELETE", path = "api/v1/rooms/{roomId}")
    fun deleteRoom(@Path("roomId") roomId: String): Single<JsonObject>

    // Stop Room
    @POST("api/v1/rooms/{roomId}/stop")
    fun stopRoom(@Path("roomId") roomId: String): Single<EkoRoomQueryDto>

    // Get Recorded Urls
    @GET("api/v1/rooms/{roomId}/recorded")
    fun getRoomRecordedUrls(@Path("roomId") roomId: String): Single<EkoRoomRecordedUrlsDto>
}