package com.ekoapp.ekosdk.internal.usecase.permission

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.permission.PermissionRepository
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import io.reactivex.rxjava3.core.Flowable

internal class GlobalPermissionValidatorUseCase {

    fun execute(permission: AmityPermission): Flowable<Boolean> {
        return PermissionRepository().getGlobalPermission(AmityCoreClient.getUserId())
            .map { it.contains(permission) }
    }

}