/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.SubChannelMarkerEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.SubChannelMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class SubChannelMarkerDao_Impl
extends SubChannelMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<SubChannelMarkerEntity> __insertAdapterOfSubChannelMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<SubChannelMarkerEntity> __deleteAdapterOfSubChannelMarkerEntity;
    private final EntityDeleteOrUpdateAdapter<SubChannelMarkerEntity> __updateAdapterOfSubChannelMarkerEntity;

    public SubChannelMarkerDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfSubChannelMarkerEntity = new EntityInsertAdapter<SubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `sub_channel_marker` (`subChannelId`,`channelId`,`lastSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                statement.bindLong(3, (long)entity.getLastSegment());
                String _tmp = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfSubChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<SubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `sub_channel_marker` WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfSubChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<SubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `sub_channel_marker` SET `subChannelId` = ?,`channelId` = ?,`lastSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                statement.bindLong(3, (long)entity.getLastSegment());
                String _tmp = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = SubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getSubChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(SubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelMarkerEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends SubChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelMarkerEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(SubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends SubChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelMarkerEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(SubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfSubChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(SubChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelMarkerDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends SubChannelMarkerEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelMarkerDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(SubChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelMarkerDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public SubChannelMarkerEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from sub_channel_marker where subChannelId = ? LIMIT 1";
        return (SubChannelMarkerEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel_marker where subChannelId = ? LIMIT 1");){
                SubChannelMarkerEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelMarkerEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelMarkerEntity subChannelMarkerEntity = _result;
                return subChannelMarkerEntity;
            }
        });
    }

    @Override
    public Flowable<SubChannelMarkerEntity> getById(String subChannelId) {
        String _sql = "SELECT * from sub_channel_marker where subChannelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel_marker"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel_marker where subChannelId = ? LIMIT 1");){
                SubChannelMarkerEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelMarkerEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelMarkerEntity subChannelMarkerEntity = _result;
                return subChannelMarkerEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from sub_channel_marker";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from sub_channel_marker");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String subChannelId) {
        String _sql = "DELETE from sub_channel_marker where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from sub_channel_marker where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

