/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.paging.DataSource;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoCommentDao_Impl
extends EkoCommentDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<CommentEntity> __insertAdapterOfCommentEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final EntityDeleteOrUpdateAdapter<CommentEntity> __deleteAdapterOfCommentEntity;
    private final EntityDeleteOrUpdateAdapter<CommentEntity> __updateAdapterOfCommentEntity;

    public EkoCommentDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfCommentEntity = new EntityInsertAdapter<CommentEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `comment` (`commentId`,`path`,`referenceType`,`referenceId`,`userId`,`parentId`,`rootId`,`dataType`,`dataTypes`,`data`,`attachments`,`metadata`,`childrenNumber`,`flagCount`,`reactions`,`reactionCount`,`isDeleted`,`editedAt`,`syncState`,`segmentNumber`,`mentionees`,`targetType`,`targetId`,`pii`,`myReactions`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommentEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getPath());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReferenceId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getParentId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getParentId());
                }
                if (entity.getRootId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getRootId());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getDataType());
                }
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(entity.getDataTypes());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getAttachments());
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_2);
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                statement.bindLong(13, (long)entity.getChildrenNumber());
                statement.bindLong(14, (long)entity.getFlagCount());
                String _tmp_4 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_4 == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmp_4);
                }
                statement.bindLong(16, (long)entity.getReactionCount());
                int _tmp_5 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_5);
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_6);
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getSyncState());
                }
                statement.bindLong(20, (long)entity.getSegmentNumber());
                String _tmp_7 = EkoCommentDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, entity.getTargetId());
                }
                String _tmp_8 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_8 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_8);
                }
                String _tmp_9 = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(entity.getMyReactions());
                if (_tmp_9 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_9);
                }
                String _tmp_10 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_10);
                }
                String _tmp_11 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_11);
                }
                String _tmp_12 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_12 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_12);
                }
            }
        };
        this.__deleteAdapterOfCommentEntity = new EntityDeleteOrUpdateAdapter<CommentEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `comment` WHERE `commentId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommentEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
            }
        };
        this.__updateAdapterOfCommentEntity = new EntityDeleteOrUpdateAdapter<CommentEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `comment` SET `commentId` = ?,`path` = ?,`referenceType` = ?,`referenceId` = ?,`userId` = ?,`parentId` = ?,`rootId` = ?,`dataType` = ?,`dataTypes` = ?,`data` = ?,`attachments` = ?,`metadata` = ?,`childrenNumber` = ?,`flagCount` = ?,`reactions` = ?,`reactionCount` = ?,`isDeleted` = ?,`editedAt` = ?,`syncState` = ?,`segmentNumber` = ?,`mentionees` = ?,`targetType` = ?,`targetId` = ?,`pii` = ?,`myReactions` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `commentId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommentEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getPath());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReferenceId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getParentId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getParentId());
                }
                if (entity.getRootId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getRootId());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getDataType());
                }
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(entity.getDataTypes());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getAttachments());
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_2);
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                statement.bindLong(13, (long)entity.getChildrenNumber());
                statement.bindLong(14, (long)entity.getFlagCount());
                String _tmp_4 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_4 == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmp_4);
                }
                statement.bindLong(16, (long)entity.getReactionCount());
                int _tmp_5 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_5);
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_6);
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getSyncState());
                }
                statement.bindLong(20, (long)entity.getSegmentNumber());
                String _tmp_7 = EkoCommentDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, entity.getTargetId());
                }
                String _tmp_8 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_8 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_8);
                }
                String _tmp_9 = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(entity.getMyReactions());
                if (_tmp_9 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_9);
                }
                String _tmp_10 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_10);
                }
                String _tmp_11 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_11);
                }
                String _tmp_12 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_12 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_12);
                }
                if (entity.getCommentId() == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, entity.getCommentId());
                }
            }
        };
    }

    @Override
    public void insertImpl(CommentEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommentEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends CommentEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommentEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(CommentEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommentEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends CommentEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommentEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(CommentEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfCommentEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(CommentEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends CommentEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(CommentEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            @NonNull
            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    @NonNull
                    protected List<CommentEntity> convertRows(@NonNull SQLiteStatement statement) {
                        int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"commentId");
                        int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"path");
                        int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceType");
                        int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceId");
                        int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"userId");
                        int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"parentId");
                        int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"rootId");
                        int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataType");
                        int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataTypes");
                        int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"data");
                        int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"attachments");
                        int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"metadata");
                        int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"childrenNumber");
                        int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"flagCount");
                        int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactions");
                        int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactionCount");
                        int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"isDeleted");
                        int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"editedAt");
                        int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"syncState");
                        int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"segmentNumber");
                        int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"mentionees");
                        int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetType");
                        int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetId");
                        int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"pii");
                        int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"myReactions");
                        int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"createdAt");
                        int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"updatedAt");
                        int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>();
                        while (statement.step()) {
                            String _tmpCommentId = statement.isNull(_columnIndexOfCommentId) ? null : statement.getText(_columnIndexOfCommentId);
                            String _tmpPath = statement.isNull(_columnIndexOfPath) ? null : statement.getText(_columnIndexOfPath);
                            String _tmpReferenceType = statement.isNull(_columnIndexOfReferenceType) ? null : statement.getText(_columnIndexOfReferenceType);
                            String _tmpReferenceId = statement.isNull(_columnIndexOfReferenceId) ? null : statement.getText(_columnIndexOfReferenceId);
                            String _tmpUserId = statement.isNull(_columnIndexOfUserId) ? null : statement.getText(_columnIndexOfUserId);
                            String _tmpParentId = statement.isNull(_columnIndexOfParentId) ? null : statement.getText(_columnIndexOfParentId);
                            String _tmpRootId = statement.isNull(_columnIndexOfRootId) ? null : statement.getText(_columnIndexOfRootId);
                            String _tmpDataType = statement.isNull(_columnIndexOfDataType) ? null : statement.getText(_columnIndexOfDataType);
                            String _tmp_4 = statement.isNull(_columnIndexOfDataTypes) ? null : statement.getText(_columnIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = statement.isNull(_columnIndexOfData) ? null : statement.getText(_columnIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = statement.isNull(_columnIndexOfAttachments) ? null : statement.getText(_columnIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = statement.isNull(_columnIndexOfMetadata) ? null : statement.getText(_columnIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = (int)statement.getLong(_columnIndexOfChildrenNumber);
                            int _tmpFlagCount = (int)statement.getLong(_columnIndexOfFlagCount);
                            String _tmp_8 = statement.isNull(_columnIndexOfReactions) ? null : statement.getText(_columnIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = (int)statement.getLong(_columnIndexOfReactionCount);
                            int _tmp_9 = (int)statement.getLong(_columnIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = statement.isNull(_columnIndexOfEditedAt) ? null : statement.getText(_columnIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = statement.isNull(_columnIndexOfSyncState) ? null : statement.getText(_columnIndexOfSyncState);
                            int _tmpSegmentNumber = (int)statement.getLong(_columnIndexOfSegmentNumber);
                            String _tmp_11 = statement.isNull(_columnIndexOfMentionees) ? null : statement.getText(_columnIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = statement.isNull(_columnIndexOfTargetType) ? null : statement.getText(_columnIndexOfTargetType);
                            String _tmpTargetId = statement.isNull(_columnIndexOfTargetId) ? null : statement.getText(_columnIndexOfTargetId);
                            String _tmp_12 = statement.isNull(_columnIndexOfPii) ? null : statement.getText(_columnIndexOfPii);
                            JsonArray _tmpPii = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_12);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                            String _tmp_13 = statement.isNull(_columnIndexOfMyReactions) ? null : statement.getText(_columnIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_13);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_14 = statement.isNull(_columnIndexOfCreatedAt) ? null : statement.getText(_columnIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_15 = statement.isNull(_columnIndexOfUpdatedAt) ? null : statement.getText(_columnIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_16 = statement.isNull(_columnIndexOfExpiresAt) ? null : statement.getText(_columnIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<List<CommentEntity>> getAllByIdsImpl(List<String> commentIds, Boolean isDeleted, Boolean isSortByCreatedACS) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT comment.* from comment where comment.commentId in (");
        int _inputSize = commentIds == null ? 1 : commentIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")  and comment.isDeleted = (case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then isDeleted else ");
        _stringBuilder.append("?");
        _stringBuilder.append(" end) order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then comment.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then comment.createdAt end desc");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                Integer _tmp_3;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (commentIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : commentIds) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 1 + _inputSize;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2 + _inputSize;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3 + _inputSize;
                Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_2.intValue());
                }
                _argIndex = 4 + _inputSize;
                Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_4);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_9 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_9 != 0;
                    String _tmp_10 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_12);
                    CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_13);
                    _item_1.setMyReactions(_tmpMyReactions);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, String parentId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)7);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceId);
        }
        _argIndex = 5;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, parentId);
        }
        _argIndex = 6;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 7;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            @NonNull
            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    @NonNull
                    protected List<CommentEntity> convertRows(@NonNull SQLiteStatement statement) {
                        int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"commentId");
                        int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"path");
                        int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceType");
                        int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceId");
                        int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"userId");
                        int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"parentId");
                        int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"rootId");
                        int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataType");
                        int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataTypes");
                        int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"data");
                        int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"attachments");
                        int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"metadata");
                        int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"childrenNumber");
                        int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"flagCount");
                        int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactions");
                        int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactionCount");
                        int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"isDeleted");
                        int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"editedAt");
                        int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"syncState");
                        int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"segmentNumber");
                        int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"mentionees");
                        int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetType");
                        int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetId");
                        int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"pii");
                        int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"myReactions");
                        int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"createdAt");
                        int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"updatedAt");
                        int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>();
                        while (statement.step()) {
                            String _tmpCommentId = statement.isNull(_columnIndexOfCommentId) ? null : statement.getText(_columnIndexOfCommentId);
                            String _tmpPath = statement.isNull(_columnIndexOfPath) ? null : statement.getText(_columnIndexOfPath);
                            String _tmpReferenceType = statement.isNull(_columnIndexOfReferenceType) ? null : statement.getText(_columnIndexOfReferenceType);
                            String _tmpReferenceId = statement.isNull(_columnIndexOfReferenceId) ? null : statement.getText(_columnIndexOfReferenceId);
                            String _tmpUserId = statement.isNull(_columnIndexOfUserId) ? null : statement.getText(_columnIndexOfUserId);
                            String _tmpParentId = statement.isNull(_columnIndexOfParentId) ? null : statement.getText(_columnIndexOfParentId);
                            String _tmpRootId = statement.isNull(_columnIndexOfRootId) ? null : statement.getText(_columnIndexOfRootId);
                            String _tmpDataType = statement.isNull(_columnIndexOfDataType) ? null : statement.getText(_columnIndexOfDataType);
                            String _tmp_4 = statement.isNull(_columnIndexOfDataTypes) ? null : statement.getText(_columnIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = statement.isNull(_columnIndexOfData) ? null : statement.getText(_columnIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = statement.isNull(_columnIndexOfAttachments) ? null : statement.getText(_columnIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = statement.isNull(_columnIndexOfMetadata) ? null : statement.getText(_columnIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = (int)statement.getLong(_columnIndexOfChildrenNumber);
                            int _tmpFlagCount = (int)statement.getLong(_columnIndexOfFlagCount);
                            String _tmp_8 = statement.isNull(_columnIndexOfReactions) ? null : statement.getText(_columnIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = (int)statement.getLong(_columnIndexOfReactionCount);
                            int _tmp_9 = (int)statement.getLong(_columnIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = statement.isNull(_columnIndexOfEditedAt) ? null : statement.getText(_columnIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = statement.isNull(_columnIndexOfSyncState) ? null : statement.getText(_columnIndexOfSyncState);
                            int _tmpSegmentNumber = (int)statement.getLong(_columnIndexOfSegmentNumber);
                            String _tmp_11 = statement.isNull(_columnIndexOfMentionees) ? null : statement.getText(_columnIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = statement.isNull(_columnIndexOfTargetType) ? null : statement.getText(_columnIndexOfTargetType);
                            String _tmpTargetId = statement.isNull(_columnIndexOfTargetId) ? null : statement.getText(_columnIndexOfTargetId);
                            String _tmp_12 = statement.isNull(_columnIndexOfPii) ? null : statement.getText(_columnIndexOfPii);
                            JsonArray _tmpPii = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_12);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                            String _tmp_13 = statement.isNull(_columnIndexOfMyReactions) ? null : statement.getText(_columnIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_13);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_14 = statement.isNull(_columnIndexOfCreatedAt) ? null : statement.getText(_columnIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_15 = statement.isNull(_columnIndexOfUpdatedAt) ? null : statement.getText(_columnIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_16 = statement.isNull(_columnIndexOfExpiresAt) ? null : statement.getText(_columnIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindText(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            @NonNull
            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    @NonNull
                    protected List<CommentEntity> convertRows(@NonNull SQLiteStatement statement) {
                        int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"commentId");
                        int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"path");
                        int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceType");
                        int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"referenceId");
                        int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"userId");
                        int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"parentId");
                        int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"rootId");
                        int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataType");
                        int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"dataTypes");
                        int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"data");
                        int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"attachments");
                        int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"metadata");
                        int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"childrenNumber");
                        int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"flagCount");
                        int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactions");
                        int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"reactionCount");
                        int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"isDeleted");
                        int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"editedAt");
                        int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"syncState");
                        int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"segmentNumber");
                        int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"mentionees");
                        int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetType");
                        int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"targetId");
                        int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"pii");
                        int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"myReactions");
                        int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"createdAt");
                        int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"updatedAt");
                        int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)statement, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>();
                        while (statement.step()) {
                            String _tmpCommentId = statement.isNull(_columnIndexOfCommentId) ? null : statement.getText(_columnIndexOfCommentId);
                            String _tmpPath = statement.isNull(_columnIndexOfPath) ? null : statement.getText(_columnIndexOfPath);
                            String _tmpReferenceType = statement.isNull(_columnIndexOfReferenceType) ? null : statement.getText(_columnIndexOfReferenceType);
                            String _tmpReferenceId = statement.isNull(_columnIndexOfReferenceId) ? null : statement.getText(_columnIndexOfReferenceId);
                            String _tmpUserId = statement.isNull(_columnIndexOfUserId) ? null : statement.getText(_columnIndexOfUserId);
                            String _tmpParentId = statement.isNull(_columnIndexOfParentId) ? null : statement.getText(_columnIndexOfParentId);
                            String _tmpRootId = statement.isNull(_columnIndexOfRootId) ? null : statement.getText(_columnIndexOfRootId);
                            String _tmpDataType = statement.isNull(_columnIndexOfDataType) ? null : statement.getText(_columnIndexOfDataType);
                            String _tmp_4 = statement.isNull(_columnIndexOfDataTypes) ? null : statement.getText(_columnIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = statement.isNull(_columnIndexOfData) ? null : statement.getText(_columnIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = statement.isNull(_columnIndexOfAttachments) ? null : statement.getText(_columnIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = statement.isNull(_columnIndexOfMetadata) ? null : statement.getText(_columnIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = (int)statement.getLong(_columnIndexOfChildrenNumber);
                            int _tmpFlagCount = (int)statement.getLong(_columnIndexOfFlagCount);
                            String _tmp_8 = statement.isNull(_columnIndexOfReactions) ? null : statement.getText(_columnIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = (int)statement.getLong(_columnIndexOfReactionCount);
                            int _tmp_9 = (int)statement.getLong(_columnIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = statement.isNull(_columnIndexOfEditedAt) ? null : statement.getText(_columnIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = statement.isNull(_columnIndexOfSyncState) ? null : statement.getText(_columnIndexOfSyncState);
                            int _tmpSegmentNumber = (int)statement.getLong(_columnIndexOfSegmentNumber);
                            String _tmp_11 = statement.isNull(_columnIndexOfMentionees) ? null : statement.getText(_columnIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = statement.isNull(_columnIndexOfTargetType) ? null : statement.getText(_columnIndexOfTargetType);
                            String _tmpTargetId = statement.isNull(_columnIndexOfTargetId) ? null : statement.getText(_columnIndexOfTargetId);
                            String _tmp_12 = statement.isNull(_columnIndexOfPii) ? null : statement.getText(_columnIndexOfPii);
                            JsonArray _tmpPii = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_12);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                            String _tmp_13 = statement.isNull(_columnIndexOfMyReactions) ? null : statement.getText(_columnIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_13);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_14 = statement.isNull(_columnIndexOfCreatedAt) ? null : statement.getText(_columnIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_15 = statement.isNull(_columnIndexOfUpdatedAt) ? null : statement.getText(_columnIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_16 = statement.isNull(_columnIndexOfExpiresAt) ? null : statement.getText(_columnIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<CommentEntity> getLatestParentCommentImpl(String referenceType, String referenceId, Boolean isDeleted, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId is null and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.updatedAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId is null and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.updatedAt  desc limit 1");){
                CommentEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 4;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 5;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 6;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 7;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_3);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_11);
                    _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_12);
                    _result.setMyReactions(_tmpMyReactions);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommentEntity commentEntity = _result;
                return commentEntity;
            }
        });
    }

    @Override
    Flowable<CommentEntity> getLatestChildCommentImpl(String referenceType, String referenceId, String parentId, Boolean isDeleted, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId = ? and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.createdAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId = ? and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.createdAt  desc limit 1");){
                CommentEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 4;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 5;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 6;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 7;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 8;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_3);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_11);
                    _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_12);
                    _result.setMyReactions(_tmpMyReactions);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommentEntity commentEntity = _result;
                return commentEntity;
            }
        });
    }

    @Override
    List<CommentEntity> getLatestCommentsImpl(String referenceType, String referenceId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5");){
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_9);
                    _item.setMyReactions(_tmpMyReactions);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    List<CommentEntity> getLatestRepliesImpl(String parentId, String referenceType, String referenceId, boolean isSortByCreatedACS) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5");){
                int _argIndex = 1;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 4;
                int _tmp = isSortByCreatedACS ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 5;
                int _tmp_1 = isSortByCreatedACS ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_6);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_7 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_7 != 0;
                    String _tmp_8 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_10);
                    CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_11);
                    _item.setMyReactions(_tmpMyReactions);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterImpl(String referenceType, String referenceId, Boolean isSortByCreatedACS, Boolean isDeleted, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc");){
                Integer _tmp_4;
                Integer _tmp_3;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 4;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 5;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 6;
                Integer n3 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 7;
                Integer n4 = isSortByCreatedACS == null ? null : (_tmp_4 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_5);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_10 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_10 != 0;
                    String _tmp_11 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_13);
                    CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_14);
                    _item.setMyReactions(_tmpMyReactions);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterFilterByParentImpl(String referenceType, String referenceId, String parentId, Boolean isSortByCreatedACS, Boolean isDeleted, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc");){
                Integer _tmp_4;
                Integer _tmp_3;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 5;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 6;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 7;
                Integer n3 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 8;
                Integer n4 = isSortByCreatedACS == null ? null : (_tmp_4 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_5);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_10 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_10 != 0;
                    String _tmp_11 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_13);
                    CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_14);
                    _item.setMyReactions(_tmpMyReactions);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public DateTime getCommentCreatedTime(String commentId) {
        String _sql = "SELECT createdAt from comment where commentId = ?";
        return (DateTime)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT createdAt from comment where commentId = ?");){
                DateTime _result;
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                if (_stmt.step()) {
                    String _tmp = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                } else {
                    _result = null;
                }
                DateTime dateTime = _result;
                return dateTime;
            }
        });
    }

    @Override
    CommentEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from comment where comment.commentId = ? LIMIT 1";
        return (CommentEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment where comment.commentId = ? LIMIT 1");){
                CommentEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setMyReactions(_tmpMyReactions);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommentEntity commentEntity = _result;
                return commentEntity;
            }
        });
    }

    @Override
    List<CommentEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from comment where comment.commentId IN (");
        int _inputSize = ids == null ? 1 : ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (ids == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : ids) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_9);
                    _item_1.setMyReactions(_tmpMyReactions);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<CommentEntity> getByIdImpl(String commentId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "comment_flag"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1");){
                CommentEntity _result;
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setMyReactions(_tmpMyReactions);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommentEntity commentEntity = _result;
                return commentEntity;
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> getByCommentIdsImpl(List<String> commentIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from comment where comment.commentId IN (");
        int _inputSize = commentIds == null ? 1 : commentIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (commentIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : commentIds) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfRootId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rootId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfDataTypes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataTypes");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfAttachments = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachments");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSegmentNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segmentNumber");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfMyReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"myReactions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>();
                while (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    String _tmpRootId = _stmt.isNull(_columnIndexOfRootId) ? null : _stmt.getText(_columnIndexOfRootId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfDataTypes) ? null : _stmt.getText(_columnIndexOfDataTypes);
                    List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAttachments) ? null : _stmt.getText(_columnIndexOfAttachments);
                    JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    int _tmpSegmentNumber = (int)_stmt.getLong(_columnIndexOfSegmentNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId, _tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMyReactions) ? null : _stmt.getText(_columnIndexOfMyReactions);
                    List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_9);
                    _item_1.setMyReactions(_tmpMyReactions);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommentEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from comment";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from comment");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void decrementChildCount(String parentId) {
        String _sql = "UPDATE comment set childrenNumber = MAX(childrenNumber - 1, 0)  where commentId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set childrenNumber = MAX(childrenNumber - 1, 0)  where commentId = ?");){
                int _argIndex = 1;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void initSyncStateOnStartup() {
        String _sql = "UPDATE comment set syncState = 'failed' where syncState = 'syncing'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set syncState = 'failed' where syncState = 'syncing'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable softDeleteById(String commentId) {
        String _sql = "UPDATE comment set isDeleted = 1 where commentId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set isDeleted = 1 where commentId = ?");){
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable deleteById(String commentId) {
        String _sql = "DELETE from comment where commentId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from comment where commentId = ?");){
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable deleteByReferenceId(String referenceId) {
        String _sql = "DELETE from comment where referenceId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from comment where referenceId = ?");){
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void updateComment(String commentId) {
        String _sql = "UPDATE comment set commentId = commentId where commentId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set commentId = commentId where commentId = ?");){
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void markAllDeletedBeforeCreatedAt(Boolean isReply, DateTime createdAt) {
        String _sql = "UPDATE comment set isDeleted = 1 where createdAt < ? and parentId = (case when ? = 1 then parentId is not null else parentId is null end)";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set isDeleted = 1 where createdAt < ? and parentId = (case when ? = 1 then parentId is not null else parentId is null end)");){
                Integer _tmp_1;
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                Integer n = isReply == null ? null : (_tmp_1 = Integer.valueOf(isReply != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _stmt.step();
                Object var8_8 = null;
                return var8_8;
            }
        });
    }

    @Override
    public void markAllDeletedAfterCreatedAt(Boolean isReply, DateTime createdAt) {
        String _sql = "UPDATE comment set isDeleted = 1 where createdAt > ? and parentId = (case when ? = 1 then parentId is not null else parentId is null end)";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE comment set isDeleted = 1 where createdAt > ? and parentId = (case when ? = 1 then parentId is not null else parentId is null end)");){
                Integer _tmp_1;
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                Integer n = isReply == null ? null : (_tmp_1 = Integer.valueOf(isReply != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _stmt.step();
                Object var8_8 = null;
                return var8_8;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

