/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.session;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity;
import com.amity.socialcloud.sdk.video.data.session.EkoStreamSessionDao;
import com.amity.socialcloud.sdk.video.data.stream.StreamSessionSyncState;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoStreamSessionDao_Impl
extends EkoStreamSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoStreamSessionEntity> __insertAdapterOfEkoStreamSessionEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoStreamSessionEntity> __deleteAdapterOfEkoStreamSessionEntity;
    private final EntityDeleteOrUpdateAdapter<EkoStreamSessionEntity> __updateAdapterOfEkoStreamSessionEntity;

    public EkoStreamSessionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoStreamSessionEntity = new EntityInsertAdapter<EkoStreamSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `stream_session` (`sessionId`,`streamId`,`title`,`watchSeconds`,`startTime`,`endTime`,`resolution`,`syncState`,`syncedAt`,`retryCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
                if (entity.getStreamId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStreamId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                statement.bindLong(4, entity.getWatchSeconds());
                String _tmp = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                if (entity.getResolution() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getResolution());
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSyncState());
                }
                String _tmp_2 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSyncedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                statement.bindLong(10, (long)entity.getRetryCount());
                String _tmp_3 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                String _tmp_5 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_5);
                }
            }
        };
        this.__deleteAdapterOfEkoStreamSessionEntity = new EntityDeleteOrUpdateAdapter<EkoStreamSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `stream_session` WHERE `sessionId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
            }
        };
        this.__updateAdapterOfEkoStreamSessionEntity = new EntityDeleteOrUpdateAdapter<EkoStreamSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `stream_session` SET `sessionId` = ?,`streamId` = ?,`title` = ?,`watchSeconds` = ?,`startTime` = ?,`endTime` = ?,`resolution` = ?,`syncState` = ?,`syncedAt` = ?,`retryCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `sessionId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
                if (entity.getStreamId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStreamId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                statement.bindLong(4, entity.getWatchSeconds());
                String _tmp = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                if (entity.getResolution() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getResolution());
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSyncState());
                }
                String _tmp_2 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSyncedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                statement.bindLong(10, (long)entity.getRetryCount());
                String _tmp_3 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                String _tmp_5 = EkoStreamSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_5);
                }
                if (entity.getSessionId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getSessionId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoStreamSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoStreamSessionEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoStreamSessionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoStreamSessionEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoStreamSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoStreamSessionEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoStreamSessionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoStreamSessionEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoStreamSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoStreamSessionEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoStreamSessionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamSessionDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoStreamSessionEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamSessionDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoStreamSessionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamSessionDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateSyncState(StreamSessionSyncState fromState, StreamSessionSyncState toState) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamSessionDao_Impl.super.updateSyncState(fromState, toState);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<List<EkoStreamSessionEntity>> getAllImpl(String[] syncStates) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from stream_session where syncState in (");
        int _inputSize = syncStates.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND watchSeconds > 0 order by startTime DESC");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream_session"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : syncStates) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfSessionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sessionId");
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfWatchSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watchSeconds");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSyncedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncedAt");
                int _columnIndexOfRetryCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retryCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoStreamSessionEntity> _result = new ArrayList<EkoStreamSessionEntity>();
                while (_stmt.step()) {
                    EkoStreamSessionEntity _item_1 = new EkoStreamSessionEntity();
                    String _tmpSessionId = _stmt.isNull(_columnIndexOfSessionId) ? null : _stmt.getText(_columnIndexOfSessionId);
                    _item_1.setSessionId(_tmpSessionId);
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _item_1.setStreamId(_tmpStreamId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _item_1.setTitle(_tmpTitle);
                    long _tmpWatchSeconds = _stmt.getLong(_columnIndexOfWatchSeconds);
                    _item_1.setWatchSeconds(_tmpWatchSeconds);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setEndTime(_tmpEndTime);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _item_1.setResolution(_tmpResolution);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item_1.setSyncState(_tmpSyncState);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfSyncedAt) ? null : _stmt.getText(_columnIndexOfSyncedAt);
                    DateTime _tmpSyncedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setSyncedAt(_tmpSyncedAt);
                    int _tmpRetryCount = (int)_stmt.getLong(_columnIndexOfRetryCount);
                    _item_1.setRetryCount(_tmpRetryCount);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EkoStreamSessionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoStreamSessionEntity> getByIdImpl(String sessionId) {
        String _sql = "SELECT * from stream_session where sessionId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream_session"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from stream_session where sessionId = ?");){
                EkoStreamSessionEntity _result;
                int _argIndex = 1;
                if (sessionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sessionId);
                }
                int _columnIndexOfSessionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sessionId");
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfWatchSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watchSeconds");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSyncedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncedAt");
                int _columnIndexOfRetryCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retryCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoStreamSessionEntity();
                    String _tmpSessionId = _stmt.isNull(_columnIndexOfSessionId) ? null : _stmt.getText(_columnIndexOfSessionId);
                    _result.setSessionId(_tmpSessionId);
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    long _tmpWatchSeconds = _stmt.getLong(_columnIndexOfWatchSeconds);
                    _result.setWatchSeconds(_tmpWatchSeconds);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setEndTime(_tmpEndTime);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _result.setResolution(_tmpResolution);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfSyncedAt) ? null : _stmt.getText(_columnIndexOfSyncedAt);
                    DateTime _tmpSyncedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setSyncedAt(_tmpSyncedAt);
                    int _tmpRetryCount = (int)_stmt.getLong(_columnIndexOfRetryCount);
                    _result.setRetryCount(_tmpRetryCount);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoStreamSessionEntity ekoStreamSessionEntity = _result;
                return ekoStreamSessionEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from stream_session";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from stream_session");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateSyncStateImpl(String fromState, String toState) {
        String _sql = "UPDATE stream_session set syncState = ? where syncState = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE stream_session set syncState = ? where syncState = ?");){
                int _argIndex = 1;
                if (toState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, toState);
                }
                _argIndex = 2;
                if (fromState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, fromState);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

