/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.dto.community.JoinRequestDto;
import com.amity.socialcloud.sdk.dto.community.JoinRequestQueryDto;
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity;
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityStorySettings;
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequest;
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequestStatus;
import com.amity.socialcloud.sdk.model.social.community.AmityJoinResult;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestEntityMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestModelMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestPersister;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunityJoinRequestQueryMediator;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunityQueryMediator;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunitySearchMediator;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunitySemanticSearchMediator;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002JI\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001cJI\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f0\u000e2\u0006\u0010\u001b\u001a\u00020\u001aJ\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f0\u000e2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0097\u0001\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\t2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001a2\b\u0010'\u001a\u0004\u0018\u00010(2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\b\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u001a2\b\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u00101J\u0091\u0001\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u00103\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\t2\b\u0010$\u001a\u0004\u0018\u00010\t2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001a2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u001a2\b\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0004\u0018\u00010\u00032\u0006\u00103\u001a\u00020\tJ\u000e\u00106\u001a\u00020\u00072\u0006\u00103\u001a\u00020\tJ>\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00120\u000e2\u0006\u00103\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tJ \u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u001f0\u000e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ\u0014\u0010?\u001a\b\u0012\u0004\u0012\u0002080\"2\u0006\u00103\u001a\u00020\tJ\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\"2\u0006\u00103\u001a\u00020\tJ\u0016\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tJ\u0016\u0010E\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tJ\u0016\u0010F\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tJ\u0016\u0010G\u001a\n\u0012\u0004\u0012\u000208\u0018\u00010\u001f2\u0006\u0010C\u001a\u00020\tJ\u000e\u0010H\u001a\u00020\u00072\u0006\u00103\u001a\u00020\tJ\u000e\u0010I\u001a\u00020\u00072\u0006\u00103\u001a\u00020\tJ;\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0010\u00a2\u0006\u0002\u0010NJF\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u000e2\u0006\u0010P\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010S2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u001aJ\u001c\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010C\u001a\u00020\t2\u0006\u0010U\u001a\u00020VJ\u0014\u0010W\u001a\u00020\u00072\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ \u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f0\u000e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ\u0015\u0010Y\u001a\u00020Z2\u0006\u00103\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b[\u00a8\u0006\\"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunity;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getDefaultPageSize", "", "getCommunityPagingData", "Landroidx/paging/PagingData;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;", "isDeleted", "", "includeDiscoverablePrivateCommunity", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;Ljava/lang/Boolean;Z)Lio/reactivex/rxjava3/core/Flowable;", "searchCommunityPagingData", "getRecommendedCommunities", "", "getTrendingCommunities", "createCommunity", "Lio/reactivex/rxjava3/core/Single;", "displayName", "description", "categoryIds", "isPublic", "metadata", "Lcom/google/gson/JsonObject;", "userIds", "avatarFileId", "needApprovalOnPostCreation", "onlyAdminCanPost", "storySettings", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;", "isDiscoverable", "requiresJoinApproval", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "updateCommunity", "communityId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "getCommunityById", "joinCommunity", "getJoinRequestPagingData", "Lcom/amity/socialcloud/sdk/model/social/community/AmityJoinRequest;", "status", "Lcom/amity/socialcloud/sdk/model/social/community/AmityJoinRequestStatus;", "targetType", "type", "getJoinRequestList", "communityIds", "getMyJoinRequest", "joinRequest", "Lcom/amity/socialcloud/sdk/model/social/community/AmityJoinResult;", "approveJoinRequest", "targetId", "userId", "rejectJoinRequest", "cancelJoinRequest", "getJoinRequestByTargetId", "leaveCommunity", "deleteCommunity", "getLatestCommunity", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "searchCommunities", "query", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityMembershipStatusFilter;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "getPostCount", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "fetchCommunityByIds", "getCommunityByIds", "notifyChanges", "", "notifyChanges$amity_sdk_release", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommunityRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommunityRepository.kt\ncom/amity/socialcloud/sdk/social/data/community/CommunityRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,591:1\n1563#2:592\n1634#2,3:593\n*S KotlinDebug\n*F\n+ 1 CommunityRepository.kt\ncom/amity/socialcloud/sdk/social/data/community/CommunityRepository\n*L\n482#1:592\n482#1:593,3\n*E\n"})
public final class CommunityRepository
extends AmityObjectRepository<CommunityEntity, AmityCommunity> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new CommunityRemoteDataStore().getCommunity(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @Override
    @Nullable
    public CommunityEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().getCommunityById(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<CommunityEntity, AmityCommunity> mapper() {
        return new CommunityModelMapper();
    }

    @Override
    @NotNull
    public Flowable<CommunityEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().observeCommunity(objectId);
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> getCommunityPagingData(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(15, 0, true, 0, 0, 0, 58, null), null, new CommunityQueryMediator(keyword, categoryId, filter, sortBy, isDeleted, includeDiscoverablePrivateCommunity), () -> CommunityRepository.getCommunityPagingData$lambda$0(keyword, categoryId, filter, sortBy, isDeleted, includeDiscoverablePrivateCommunity), (ModelMapper)new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> searchCommunityPagingData(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, true, 0, 0, 0, 58, null), null, new CommunitySearchMediator(keyword, categoryId, filter, sortBy, isDeleted, includeDiscoverablePrivateCommunity), () -> CommunityRepository.searchCommunityPagingData$lambda$1(keyword, categoryId, filter, sortBy, isDeleted, includeDiscoverablePrivateCommunity), new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getRecommendedCommunities(boolean includeDiscoverablePrivateCommunity) {
        Flowable flowable = new CommunityRemoteDataStore().getRecommendedCommunities(new QueryOptionsRequestParams(20, null, 2, null), includeDiscoverablePrivateCommunity).flatMap((Function)getRecommendedCommunities.1.INSTANCE).flatMapPublisher((Function)getRecommendedCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getTrendingCommunities(boolean includeDiscoverablePrivateCommunity) {
        Flowable flowable = new CommunityRemoteDataStore().getTrendingCommunities(new QueryOptionsRequestParams(20, null, 2, null), includeDiscoverablePrivateCommunity).flatMap((Function)getTrendingCommunities.1.INSTANCE).flatMapPublisher((Function)getTrendingCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunity(@NotNull String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost, @Nullable AmityCommunityStorySettings storySettings, @Nullable Boolean isDiscoverable, @Nullable Boolean requiresJoinApproval) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Single single = new CommunityRemoteDataStore().createCommunity(displayName, description, categoryIds, isPublic, metadata, userIds, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost, storySettings, isDiscoverable, requiresJoinApproval).flatMap((Function)createCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    public static /* synthetic */ Single createCommunity$default(CommunityRepository communityRepository, String string, String string2, List list, Boolean bl, JsonObject jsonObject, List list2, String string3, Boolean bl2, Boolean bl3, AmityCommunityStorySettings amityCommunityStorySettings, Boolean bl4, Boolean bl5, int n, Object object) {
        if ((n & 0x400) != 0) {
            bl4 = null;
        }
        if ((n & 0x800) != 0) {
            bl5 = null;
        }
        return communityRepository.createCommunity(string, string2, list, bl, jsonObject, list2, string3, bl2, bl3, amityCommunityStorySettings, bl4, bl5);
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunity(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost, @Nullable AmityCommunityStorySettings storySettings, @Nullable Boolean isDiscoverable, @Nullable Boolean requiresJoinApproval) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = new CommunityRemoteDataStore().updateCommunity(communityId, displayName, description, categoryIds, isPublic, metadata, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost, storySettings, isDiscoverable, requiresJoinApproval).flatMap((Function)updateCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    public static /* synthetic */ Single updateCommunity$default(CommunityRepository communityRepository, String string, String string2, String string3, List list, Boolean bl, JsonObject jsonObject, String string4, Boolean bl2, Boolean bl3, AmityCommunityStorySettings amityCommunityStorySettings, Boolean bl4, Boolean bl5, int n, Object object) {
        if ((n & 0x400) != 0) {
            bl4 = null;
        }
        if ((n & 0x800) != 0) {
            bl5 = null;
        }
        return communityRepository.updateCommunity(string, string2, string3, list, bl, jsonObject, string4, bl2, bl3, amityCommunityStorySettings, bl4, bl5);
    }

    @Nullable
    public final AmityCommunity getCommunityById(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityEntity community = new CommunityLocalDataStore().getCommunityById(communityId);
        return community == null ? null : new CommunityModelMapper().map(community);
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().joinCommunity(communityId).flatMapCompletable((Function)joinCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmityJoinRequest>> getJoinRequestPagingData(@NotNull String communityId, @NotNull AmityJoinRequestStatus status, @Nullable AmityCommunitySortOption sortBy, @NotNull String targetType, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, true, 0, 0, 0, 58, null), null, new CommunityJoinRequestQueryMediator(communityId, status.getStatus(), sortBy, targetType, type2), () -> CommunityRepository.getJoinRequestPagingData$lambda$2(communityId, status, sortBy, targetType, type2), new CommunityJoinRequestModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    public static /* synthetic */ Flowable getJoinRequestPagingData$default(CommunityRepository communityRepository, String string, AmityJoinRequestStatus amityJoinRequestStatus, AmityCommunitySortOption amityCommunitySortOption, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            amityCommunitySortOption = null;
        }
        return communityRepository.getJoinRequestPagingData(string, amityJoinRequestStatus, amityCommunitySortOption, string2, string3);
    }

    @NotNull
    public final Flowable<List<AmityJoinRequest>> getJoinRequestList(@NotNull List<String> communityIds) {
        Intrinsics.checkNotNullParameter(communityIds, (String)"communityIds");
        Flowable flowable = new CommunityRemoteDataStore().getJoinRequestList(communityIds).flatMap((Function)getJoinRequestList.1.INSTANCE).flatMapPublisher((Function)getJoinRequestList.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    @NotNull
    public final Single<AmityJoinRequest> getMyJoinRequest(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = new CommunityRemoteDataStore().getMyJoinRequest(communityId).flatMap((Function)getMyJoinRequest.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Single<AmityJoinResult> joinRequest(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = new CommunityRemoteDataStore().joinRequest(communityId).flatMap(new Function(communityId, this){
            final /* synthetic */ String $communityId;
            final /* synthetic */ CommunityRepository this$0;
            {
                this.$communityId = $communityId;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final SingleSource<? extends AmityJoinResult> apply(JoinRequestQueryDto dto) {
                SingleSource singleSource;
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Completable completable = new CommunityJoinRequestPersister().persist(dto);
                List<JoinRequestDto> list = dto.getJoinRequests();
                if (list != null && (list = (JoinRequestDto)CollectionsKt.firstOrNull(list)) != null) {
                    Single single;
                    void joinRequestDto;
                    List<JoinRequestDto> list2 = list;
                    String string = this.$communityId;
                    CommunityRepository communityRepository = this.this$0;
                    List<JoinRequestDto> list3 = list2;
                    Completable completable2 = completable;
                    boolean bl = false;
                    JoinRequestEntity entity = (JoinRequestEntity)CollectionsKt.first(new CommunityJoinRequestEntityMapper().map(CollectionsKt.listOf((Object)joinRequestDto)));
                    AmityJoinRequest request = new CommunityJoinRequestModelMapper().map(entity);
                    String string2 = joinRequestDto.getStatus();
                    if (Intrinsics.areEqual((Object)string2, (Object)AmityJoinRequestStatus.APPROVED.getStatus())) {
                        single = new CommunityLocalDataStore().updateJoinCommunity(string).doOnError((Consumer)joinRequest.1.1.INSTANCE).andThen((SingleSource)Single.just((Object)new AmityJoinResult.Success()));
                    } else if (Intrinsics.areEqual((Object)string2, (Object)AmityJoinRequestStatus.PENDING.getStatus())) {
                        communityRepository.notifyChanges$amity_sdk_release(request.getTargetId());
                        single = Single.just((Object)new AmityJoinResult.Pending(request));
                    } else {
                        single = Single.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "Unknown join request status: " + joinRequestDto.getStatus(), null, AmityError.UNKNOWN, null, 8, null));
                    }
                    completable = completable2;
                    list = single;
                    if (single != null) {
                        singleSource = (SingleSource)list;
                        return (SingleSource)completable.andThen(singleSource);
                    }
                }
                singleSource = (SingleSource)Single.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "corrupted payload", null, AmityError.UNKNOWN, null, 8, null));
                return (SingleSource)completable.andThen(singleSource);
            }
        }).onErrorResumeNext((Function)joinRequest.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"onErrorResumeNext(...)");
        return single;
    }

    @NotNull
    public final Completable approveJoinRequest(@NotNull String targetId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new CommunityRemoteDataStore().approveJoinRequest(targetId, userId).flatMapCompletable(new Function(targetId, userId){
            final /* synthetic */ String $targetId;
            final /* synthetic */ String $userId;
            {
                this.$targetId = $targetId;
                this.$userId = $userId;
            }

            public final CompletableSource apply(EkoDeletionDto response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return response.isSuccess() ? (CompletableSource)new CommunityJoinRequestLocalDataStore().updateJoinRequest(this.$targetId, this.$userId, AmityJoinRequestStatus.APPROVED) : (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "Failed to approve join request", null, AmityError.UNKNOWN, null, 8, null));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable rejectJoinRequest(@NotNull String targetId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new CommunityRemoteDataStore().rejectJoinRequest(targetId, userId).flatMapCompletable(new Function(targetId, userId){
            final /* synthetic */ String $targetId;
            final /* synthetic */ String $userId;
            {
                this.$targetId = $targetId;
                this.$userId = $userId;
            }

            public final CompletableSource apply(EkoDeletionDto response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return response.isSuccess() ? (CompletableSource)new CommunityJoinRequestLocalDataStore().updateJoinRequest(this.$targetId, this.$userId, AmityJoinRequestStatus.REJECTED) : (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "Failed to reject join request", null, AmityError.UNKNOWN, null, 8, null));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable cancelJoinRequest(@NotNull String targetId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new CommunityRemoteDataStore().cancelJoinRequest(targetId).flatMapCompletable(new Function(targetId, userId, this){
            final /* synthetic */ String $targetId;
            final /* synthetic */ String $userId;
            final /* synthetic */ CommunityRepository this$0;
            {
                this.$targetId = $targetId;
                this.$userId = $userId;
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(EkoDeletionDto response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return response.isSuccess() ? (CompletableSource)new CommunityJoinRequestLocalDataStore().deleteJoinRequest(this.$targetId, this.$userId).andThen(arg_0 -> cancelJoinRequest.1.apply$lambda$0(this.this$0, this.$targetId, arg_0)) : (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "Failed to cancel join request", null, AmityError.UNKNOWN, null, 8, null));
            }

            private static final void apply$lambda$0(CommunityRepository this$0, String $targetId, CompletableObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.notifyChanges$amity_sdk_release($targetId);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<AmityJoinRequest> getJoinRequestByTargetId(@NotNull String targetId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        List<JoinRequestEntity> list2 = new CommunityJoinRequestLocalDataStore().getJoinRequestByTargetId(targetId);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            List<JoinRequestEntity> joinRequest2 = list2;
            boolean bl = false;
            Iterable $this$map$iv = joinRequest2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JoinRequestEntity joinRequestEntity = (JoinRequestEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new CommunityJoinRequestModelMapper().map((JoinRequestEntity)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().leaveCommunity(communityId).flatMapCompletable((Function)leaveCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().deleteCommunity(communityId).flatMapCompletable(new Function(communityId){
            final /* synthetic */ String $communityId;
            {
                this.$communityId = $communityId;
            }

            public final CompletableSource apply(EkoDeletionDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isSuccess() ? (CompletableSource)new CommunityLocalDataStore().deleteCommunity(this.$communityId) : (CompletableSource)Completable.complete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Flowable<AmityCommunity> getLatestCommunity(@NotNull String categoryId, @NotNull AmityCommunityFilter filter, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new CommunityLocalDataStore().getLatestCommunity(categoryId, filter, isDeleted, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> searchCommunities(@NotNull String query, @Nullable AmityCommunityMembershipStatusFilter filter, @Nullable AmityTags tags, @Nullable List<String> categoryIds, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new CommunitySemanticSearchMediator(query, filter, tags, categoryIds, includeDiscoverablePrivateCommunity), () -> CommunityRepository.searchCommunities$lambda$5(query, filter, tags, categoryIds), (ModelMapper)new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new CommunityLocalDataStore().getPostCount(targetId, feedType);
    }

    @NotNull
    public final Completable fetchCommunityByIds(@NotNull List<String> communityIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(communityIds, (String)"communityIds");
        if (communityIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            Completable completable3 = CommunityRemoteDataStore.getCommunityByIds$default(new CommunityRemoteDataStore(), communityIds, null, 2, null).flatMapCompletable((Function)fetchCommunityByIds.1.INSTANCE);
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getCommunityByIds(@NotNull List<String> communityIds) {
        Intrinsics.checkNotNullParameter(communityIds, (String)"communityIds");
        Flowable flowable = CommunityRemoteDataStore.getCommunityByIds$default(new CommunityRemoteDataStore(), communityIds, null, 2, null).flatMap((Function)getCommunityByIds.1.INSTANCE).flatMapPublisher((Function)getCommunityByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    public final void notifyChanges$amity_sdk_release(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        new CommunityLocalDataStore().notifyChanges(communityId);
    }

    private static final PagingSource getCommunityPagingData$lambda$0(String $keyword, String $categoryId, AmityCommunityFilter $filter, AmityCommunitySortOption $sortBy, Boolean $isDeleted, boolean $includeDiscoverablePrivateCommunity) {
        return new CommunityLocalDataStore().getCommunityPagingSource($keyword, $categoryId, $filter, $sortBy, $isDeleted, $includeDiscoverablePrivateCommunity);
    }

    private static final PagingSource searchCommunityPagingData$lambda$1(String $keyword, String $categoryId, AmityCommunityFilter $filter, AmityCommunitySortOption $sortBy, Boolean $isDeleted, boolean $includeDiscoverablePrivateCommunity) {
        return new CommunityLocalDataStore().searchCommunityPagingSource($keyword, $categoryId, $filter, $sortBy, $isDeleted, $includeDiscoverablePrivateCommunity);
    }

    private static final PagingSource getJoinRequestPagingData$lambda$2(String $communityId, AmityJoinRequestStatus $status, AmityCommunitySortOption $sortBy, String $targetType, String $type) {
        return new CommunityJoinRequestLocalDataStore().getCommunityJoinRequestsPagingSource($communityId, $status.getStatus(), $sortBy, $targetType, $type);
    }

    private static final PagingSource searchCommunities$lambda$5(String $query, AmityCommunityMembershipStatusFilter $filter, AmityTags $tags, List $categoryIds) {
        return new CommunityLocalDataStore().getSearchCommunitiesPagingSource($query, $filter, $tags, $categoryIds);
    }
}

