/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.component;

import com.amity.socialcloud.sdk.core.session.AccessTokenRenewalImpl;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0011H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J\b\u0010%\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "getSessionHandler", "()Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "setSessionHandler", "(Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;)V", "currentRenewal", "Lcom/amity/socialcloud/sdk/core/session/AccessTokenRenewalImpl;", "lastFailedDateTime", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "onSessionStateChange", "", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "observeTokenEvent", "initiateRenewalIfNeeded", "initiateRenewal", "renewal", "canInitiateRenewal", "", "unableToRenewWithCurrentRenewal", "finishCurrentRenewal", "amity-sdk_release"})
public final class TokenRenewalSessionComponent
extends SessionComponent {
    @NotNull
    private final AppEventBus appEventBus;
    @Nullable
    private SessionHandler sessionHandler;
    @Nullable
    private AccessTokenRenewalImpl currentRenewal;
    private DateTime lastFailedDateTime;

    public TokenRenewalSessionComponent(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.appEventBus = appEventBus;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
        this.observeTokenEvent();
    }

    @Nullable
    public final SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public final void setSessionHandler(@Nullable SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void handleTokenExpire() {
        this.finishCurrentRenewal();
    }

    private final void observeTokenEvent() {
        this.appEventBus.observe().filter((Predicate)observeTokenEvent.1.INSTANCE).doOnNext(new Consumer(this){
            final /* synthetic */ TokenRenewalSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(AppEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TokenRenewalSessionComponent.access$initiateRenewalIfNeeded(this.this$0);
            }
        }).subscribe();
    }

    private final void initiateRenewalIfNeeded() {
        block1: {
            if (!this.canInitiateRenewal()) {
                return;
            }
            AppEventBus appEventBus = this.appEventBus;
            SessionLifeCycleEventBus sessionLifeCycleEventBus = this.getSessionLifeCycleEventBus();
            AccessTokenRenewalImpl accessTokenRenewal = new AccessTokenRenewalImpl(appEventBus, sessionLifeCycleEventBus, (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateRenewalIfNeeded$lambda$0(this)), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> TokenRenewalSessionComponent.initiateRenewalIfNeeded$lambda$1(this, arg_0)), (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateRenewalIfNeeded$lambda$2(this)));
            this.initiateRenewal(accessTokenRenewal);
            SessionHandler sessionHandler = this.sessionHandler;
            if (sessionHandler == null) break block1;
            sessionHandler.sessionWillRenewAccessToken(accessTokenRenewal);
        }
    }

    private final void initiateRenewal(AccessTokenRenewalImpl renewal) {
        this.currentRenewal = renewal;
    }

    private final boolean canInitiateRenewal() {
        if (this.currentRenewal != null) {
            return false;
        }
        Duration tenMinutes = Duration.standardMinutes((long)10L);
        return this.currentRenewal == null || !DateTime.now().isAfter((ReadableInstant)this.lastFailedDateTime.plus((ReadableDuration)tenMinutes));
    }

    private final void unableToRenewWithCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now();
    }

    private final void finishCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
    }

    private static final Unit initiateRenewalIfNeeded$lambda$0(TokenRenewalSessionComponent this$0) {
        this$0.appEventBus.publish(AppEvent.TokenRenewSuccess.INSTANCE);
        this$0.finishCurrentRenewal();
        return Unit.INSTANCE;
    }

    private static final Unit initiateRenewalIfNeeded$lambda$1(TokenRenewalSessionComponent this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        AmityException amityError = AmityException.Companion.fromThrowable(throwable);
        if (amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode() || amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode()) {
            this$0.appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
            this$0.finishCurrentRenewal();
        } else {
            this$0.unableToRenewWithCurrentRenewal();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initiateRenewalIfNeeded$lambda$2(TokenRenewalSessionComponent this$0) {
        this$0.unableToRenewWithCurrentRenewal();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$initiateRenewalIfNeeded(TokenRenewalSessionComponent $this) {
        $this.initiateRenewalIfNeeded();
    }
}

