/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.ad;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.core.data.ad.AdvertiserDao;
import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class AdvertiserDao_Impl
extends AdvertiserDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<AdvertiserEntity> __insertAdapterOfAdvertiserEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<AdvertiserEntity> __deleteAdapterOfAdvertiserEntity;
    private final EntityDeleteOrUpdateAdapter<AdvertiserEntity> __updateAdapterOfAdvertiserEntity;

    public AdvertiserDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfAdvertiserEntity = new EntityInsertAdapter<AdvertiserEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `advertiser` (`advertiserId`,`name`,`companyName`,`avatarFileId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdvertiserEntity entity) {
                if (entity.getAdvertiserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getAdvertiserId());
                }
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getName());
                }
                if (entity.getCompanyName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getCompanyName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getAvatarFileId());
                }
                String _tmp = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfAdvertiserEntity = new EntityDeleteOrUpdateAdapter<AdvertiserEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `advertiser` WHERE `advertiserId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdvertiserEntity entity) {
                if (entity.getAdvertiserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getAdvertiserId());
                }
            }
        };
        this.__updateAdapterOfAdvertiserEntity = new EntityDeleteOrUpdateAdapter<AdvertiserEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `advertiser` SET `advertiserId` = ?,`name` = ?,`companyName` = ?,`avatarFileId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `advertiserId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdvertiserEntity entity) {
                if (entity.getAdvertiserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getAdvertiserId());
                }
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getName());
                }
                if (entity.getCompanyName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getCompanyName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getAvatarFileId());
                }
                String _tmp = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getAdvertiserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getAdvertiserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(AdvertiserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAdvertiserEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends AdvertiserEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAdvertiserEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(AdvertiserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAdvertiserEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends AdvertiserEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAdvertiserEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(AdvertiserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfAdvertiserEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(AdvertiserEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdvertiserDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends AdvertiserEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdvertiserDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(AdvertiserEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdvertiserDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Single<List<AdvertiserEntity>> getByIdImpl(String advertiserId) {
        String _sql = "SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1");){
                int _argIndex = 1;
                if (advertiserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, advertiserId);
                }
                int _columnIndexOfAdvertiserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"advertiserId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfCompanyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"companyName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<AdvertiserEntity> _result = new ArrayList<AdvertiserEntity>();
                while (_stmt.step()) {
                    String _tmpAdvertiserId = _stmt.isNull(_columnIndexOfAdvertiserId) ? null : _stmt.getText(_columnIndexOfAdvertiserId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    String _tmpCompanyName = _stmt.isNull(_columnIndexOfCompanyName) ? null : _stmt.getText(_columnIndexOfCompanyName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    AdvertiserEntity _item = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<AdvertiserEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public AdvertiserEntity getByIdNowImpl(String advertiserId) {
        String _sql = "SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1";
        return (AdvertiserEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1");){
                AdvertiserEntity _result;
                int _argIndex = 1;
                if (advertiserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, advertiserId);
                }
                int _columnIndexOfAdvertiserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"advertiserId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfCompanyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"companyName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpAdvertiserId = _stmt.isNull(_columnIndexOfAdvertiserId) ? null : _stmt.getText(_columnIndexOfAdvertiserId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    String _tmpCompanyName = _stmt.isNull(_columnIndexOfCompanyName) ? null : _stmt.getText(_columnIndexOfCompanyName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                AdvertiserEntity advertiserEntity = _result;
                return advertiserEntity;
            }
        });
    }

    @Override
    public List<AdvertiserEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from advertiser where advertiser.advertiserId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfAdvertiserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"advertiserId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfCompanyName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"companyName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<AdvertiserEntity> _result = new ArrayList<AdvertiserEntity>();
                while (_stmt.step()) {
                    String _tmpAdvertiserId = _stmt.isNull(_columnIndexOfAdvertiserId) ? null : _stmt.getText(_columnIndexOfAdvertiserId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    String _tmpCompanyName = _stmt.isNull(_columnIndexOfCompanyName) ? null : _stmt.getText(_columnIndexOfCompanyName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    AdvertiserEntity _item_1 = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<AdvertiserEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from advertiser";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from advertiser");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

