/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import android.os.Build;
import com.amity.socialcloud.sdk.chat.data.marker.readreceipt.ReadReceiptRepository;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.MarkMessageReadUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.UpdateReadReceiptLatestSyncSegmentUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.SubChannelReadReceiptEntity;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 +2\u00020\u0001:\u0003)*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0016\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "isActive", "", "jobQueue", "Ljava/util/LinkedList;", "Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncJob;", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "syncReadReceipts", "markRead", "syncJob", "getReadReceipt", "removeSynedReceipt", "", "subChannelId", "", "segment", "", "startObservingReadReceiptQueue", "stopObservingReadReceiptQueue", "enqueueReadReceipt", "getSyncJob", "enqueueJob", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "ReadReceiptSyncJob", "ReadReceiptSyncState", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubChannelReadReceiptSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubChannelReadReceiptSyncEngine.kt\ncom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1869#2,2:262\n1869#2,2:264\n1869#2,2:267\n295#2,2:269\n1#3:266\n*S KotlinDebug\n*F\n+ 1 SubChannelReadReceiptSyncEngine.kt\ncom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine\n*L\n40#1:262,2\n134#1:264,2\n157#1:267,2\n203#1:269,2\n*E\n"})
public final class SubChannelReadReceiptSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isActive;
    @NotNull
    private final LinkedList<ReadReceiptSyncJob> jobQueue;
    @NotNull
    private final Completable timer;
    @NotNull
    private final CompositeDisposable disposable;
    private static final int MAX_RETRY = 3;
    private static final int JOB_QUEUE_SIZE = 120;
    private static final long RECEIPT_SYNC_INTERVAL = 1L;

    public SubChannelReadReceiptSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.jobQueue = new LinkedList();
        Completable completable = Flowable.interval((long)RECEIPT_SYNC_INTERVAL, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ SubChannelReadReceiptSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)SubChannelReadReceiptSyncEngine.access$syncReadReceipts(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        this.timer = completable;
        this.disposable = new CompositeDisposable();
        Iterable $this$forEach$iv = new ReadReceiptRepository().getUnsyncLegacyReadReceipt();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubChannelReadReceiptEntity it = (SubChannelReadReceiptEntity)element$iv;
            boolean bl = false;
            this.enqueueReadReceipt(it.getSubChannelId(), it.getLatestSegment());
            this.jobQueue.add(new ReadReceiptSyncJob(it.getSubChannelId(), it.getLatestSegment(), ReadReceiptSyncState.CREATED, 0));
        }
        if (Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE)) {
            this.startObservingReadReceiptQueue();
        }
        NetworkConnectionEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(NetworkConnectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof NetworkConnectionEvent.Connected) {
                    this.startObservingReadReceiptQueue();
                } else {
                    this.stopObservingReadReceiptQueue();
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable syncReadReceipts() {
        Completable completable;
        if (this.jobQueue.size() == 0 || !this.isActive) {
            Completable completable2 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            ReadReceiptSyncJob readReceipt = this.getReadReceipt();
            if (readReceipt != null) {
                completable = this.markRead(readReceipt);
            } else {
                Completable completable3 = Completable.complete();
                Intrinsics.checkNotNull((Object)completable3);
                completable = completable3;
            }
        }
        return completable;
    }

    private final Completable markRead(ReadReceiptSyncJob syncJob) {
        syncJob.setSyncState(ReadReceiptSyncState.SYNCING);
        String subChannelId = syncJob.getSubChannelId();
        int segment = syncJob.getSegment();
        Completable completable = new MarkMessageReadUseCase().execute(subChannelId, segment).doOnComplete(() -> SubChannelReadReceiptSyncEngine.markRead$lambda$1(this, syncJob)).doOnError(new Consumer(syncJob, this){
            final /* synthetic */ ReadReceiptSyncJob $syncJob;
            final /* synthetic */ SubChannelReadReceiptSyncEngine this$0;
            {
                this.$syncJob = $syncJob;
                this.this$0 = $receiver;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$syncJob.getRetryCount() > SubChannelReadReceiptSyncEngine.Companion.getMAX_RETRY()) {
                    SubChannelReadReceiptSyncEngine.access$getJobQueue$p(this.this$0).remove(this.$syncJob);
                } else {
                    this.$syncJob.setRetryCount(this.$syncJob.getRetryCount() + 1);
                    this.$syncJob.setSyncState(ReadReceiptSyncState.CREATED);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnError(...)");
        return completable;
    }

    private final ReadReceiptSyncJob getReadReceipt() {
        ReadReceiptSyncJob readReceiptSyncJob;
        if (this.jobQueue.isEmpty()) {
            return null;
        }
        ReadReceiptSyncJob syncJob = this.jobQueue.peek();
        if (syncJob.getSyncState() == ReadReceiptSyncState.SYNCING) {
            return null;
        }
        SubChannelReadReceiptEntity readReceipt = new ReadReceiptRepository().getLegacyReadReceipt(syncJob.getSubChannelId());
        if (readReceipt != null && readReceipt.getLatestSegment() > readReceipt.getLatestSyncSegment()) {
            syncJob.setSegment(readReceipt.getLatestSegment());
            readReceiptSyncJob = syncJob;
        } else if (readReceipt != null) {
            this.removeSynedReceipt(readReceipt.getSubChannelId(), readReceipt.getLatestSyncSegment());
            readReceiptSyncJob = this.getReadReceipt();
        } else {
            readReceiptSyncJob = syncJob;
        }
        return readReceiptSyncJob;
    }

    private final void removeSynedReceipt(String subChannelId, int segment) {
        if (Build.VERSION.SDK_INT >= 24) {
            this.jobQueue.removeIf(arg_0 -> SubChannelReadReceiptSyncEngine.removeSynedReceipt$lambda$3(arg_0 -> SubChannelReadReceiptSyncEngine.removeSynedReceipt$lambda$2(subChannelId, segment, arg_0), arg_0));
        } else {
            Iterable $this$forEach$iv = this.jobQueue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReadReceiptSyncJob syncJob = (ReadReceiptSyncJob)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)syncJob.getSubChannelId(), (Object)subChannelId) || syncJob.getSegment() > segment) continue;
                this.jobQueue.remove(syncJob);
            }
        }
    }

    private final void startObservingReadReceiptQueue() {
        if (CoreClient.INSTANCE.isUnreadCountEnable()) {
            this.isActive = true;
            if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
                this.disposable.clear();
                Disposable disposable = this.timer.subscribe();
                CompositeDisposable compositeDisposable = this.disposable;
                Disposable p0 = disposable;
                boolean bl = false;
                compositeDisposable.add(p0);
            }
        }
    }

    private final void stopObservingReadReceiptQueue() {
        this.isActive = false;
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
        Iterable $this$forEach$iv = this.jobQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadReceiptSyncJob receipt = (ReadReceiptSyncJob)element$iv;
            boolean bl = false;
            if (receipt.getSyncState() != ReadReceiptSyncState.SYNCING) continue;
            receipt.setSyncState(ReadReceiptSyncState.CREATED);
        }
    }

    public final void markRead(@NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        SubChannelUnreadInfoEntity subChannelUnreadInfo = new SubChannelMarkerRepository().getSubChannelUnreadInfo(subChannelId);
        if (subChannelUnreadInfo != null && segment > subChannelUnreadInfo.getReadToSegment()) {
            subChannelUnreadInfo.setReadToSegment(segment);
            new SubChannelMarkerRepository().saveSubChannelUnreadInfo(CollectionsKt.listOf((Object)subChannelUnreadInfo));
        }
        this.enqueueReadReceipt(subChannelId, segment);
    }

    private final void enqueueReadReceipt(String subChannelId, int segment) {
        SubChannelReadReceiptEntity readReceipt;
        SubChannelReadReceiptEntity subChannelReadReceiptEntity = new ReadReceiptRepository().getLegacyReadReceipt(subChannelId);
        if (subChannelReadReceiptEntity == null) {
            SubChannelReadReceiptEntity subChannelReadReceiptEntity2;
            SubChannelReadReceiptEntity $this$enqueueReadReceipt_u24lambda_u246 = subChannelReadReceiptEntity2 = new SubChannelReadReceiptEntity();
            boolean bl = false;
            $this$enqueueReadReceipt_u24lambda_u246.setSubChannelId(subChannelId);
            $this$enqueueReadReceipt_u24lambda_u246.setLatestSegment(segment);
            $this$enqueueReadReceipt_u24lambda_u246.setLatestSyncSegment(0);
            new ReadReceiptRepository().saveLegacyReadReceipts(CollectionsKt.listOf((Object)$this$enqueueReadReceipt_u24lambda_u246));
            subChannelReadReceiptEntity = subChannelReadReceiptEntity2;
        }
        if ((readReceipt = subChannelReadReceiptEntity).getLatestSyncSegment() >= segment) {
            return;
        }
        ReadReceiptSyncJob syncJob = this.getSyncJob(subChannelId);
        if (syncJob == null || syncJob.getSyncState() == ReadReceiptSyncState.SYNCING) {
            syncJob = new ReadReceiptSyncJob(subChannelId, segment, ReadReceiptSyncState.CREATED, 0);
        } else if (syncJob.getSegment() < segment) {
            syncJob.setSegment(segment);
        }
        this.enqueueJob(syncJob);
    }

    private final ReadReceiptSyncJob getSyncJob(String subChannelId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.jobQueue;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReadReceiptSyncJob job = (ReadReceiptSyncJob)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)job.getSubChannelId(), (Object)subChannelId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void enqueueJob(ReadReceiptSyncJob syncJob) {
        if (this.jobQueue.size() < JOB_QUEUE_SIZE) {
            v0 = this.jobQueue.offer(syncJob);
        } else {
            this.jobQueue.poll();
            v0 = this.jobQueue.offer(syncJob);
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.startObservingReadReceiptQueue();
        } else {
            this.stopObservingReadReceiptQueue();
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.startObservingReadReceiptQueue();
    }

    @Override
    public void destroy() {
        this.stopObservingReadReceiptQueue();
        this.jobQueue.clear();
    }

    @Override
    public void handleTokenExpire() {
        this.stopObservingReadReceiptQueue();
    }

    private static final void markRead$lambda$1(SubChannelReadReceiptSyncEngine this$0, ReadReceiptSyncJob $syncJob) {
        this$0.removeSynedReceipt($syncJob.getSubChannelId(), $syncJob.getSegment());
        new UpdateReadReceiptLatestSyncSegmentUseCase().execute($syncJob.getSubChannelId(), $syncJob.getSegment());
    }

    private static final boolean removeSynedReceipt$lambda$2(String $subChannelId, int $segment, ReadReceiptSyncJob syncJob) {
        return Intrinsics.areEqual((Object)syncJob.getSubChannelId(), (Object)$subChannelId) && syncJob.getSegment() <= $segment;
    }

    private static final boolean removeSynedReceipt$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LinkedList access$getJobQueue$p(SubChannelReadReceiptSyncEngine $this) {
        return $this.jobQueue;
    }

    public static final /* synthetic */ Completable access$syncReadReceipts(SubChannelReadReceiptSyncEngine $this) {
        return $this.syncReadReceipts();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$Companion;", "", "<init>", "()V", "MAX_RETRY", "", "getMAX_RETRY", "()I", "JOB_QUEUE_SIZE", "getJOB_QUEUE_SIZE", "RECEIPT_SYNC_INTERVAL", "", "getRECEIPT_SYNC_INTERVAL", "()J", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_RETRY() {
            return MAX_RETRY;
        }

        public final int getJOB_QUEUE_SIZE() {
            return JOB_QUEUE_SIZE;
        }

        public final long getRECEIPT_SYNC_INTERVAL() {
            return RECEIPT_SYNC_INTERVAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncJob;", "", "subChannelId", "", "segment", "", "syncState", "Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "retryCount", "<init>", "(Ljava/lang/String;ILcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncState;I)V", "getSubChannelId", "()Ljava/lang/String;", "getSegment", "()I", "setSegment", "(I)V", "getSyncState", "()Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "setSyncState", "(Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncState;)V", "getRetryCount", "setRetryCount", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "amity-sdk_release"})
    public static final class ReadReceiptSyncJob {
        @NotNull
        private final String subChannelId;
        private int segment;
        @NotNull
        private ReadReceiptSyncState syncState;
        private int retryCount;

        public ReadReceiptSyncJob(@NotNull String subChannelId, int segment, @NotNull ReadReceiptSyncState syncState, int retryCount) {
            Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
            Intrinsics.checkNotNullParameter((Object)((Object)syncState), (String)"syncState");
            this.subChannelId = subChannelId;
            this.segment = segment;
            this.syncState = syncState;
            this.retryCount = retryCount;
        }

        @NotNull
        public final String getSubChannelId() {
            return this.subChannelId;
        }

        public final int getSegment() {
            return this.segment;
        }

        public final void setSegment(int n) {
            this.segment = n;
        }

        @NotNull
        public final ReadReceiptSyncState getSyncState() {
            return this.syncState;
        }

        public final void setSyncState(@NotNull ReadReceiptSyncState readReceiptSyncState) {
            Intrinsics.checkNotNullParameter((Object)((Object)readReceiptSyncState), (String)"<set-?>");
            this.syncState = readReceiptSyncState;
        }

        public final int getRetryCount() {
            return this.retryCount;
        }

        public final void setRetryCount(int n) {
            this.retryCount = n;
        }

        @NotNull
        public final String component1() {
            return this.subChannelId;
        }

        public final int component2() {
            return this.segment;
        }

        @NotNull
        public final ReadReceiptSyncState component3() {
            return this.syncState;
        }

        public final int component4() {
            return this.retryCount;
        }

        @NotNull
        public final ReadReceiptSyncJob copy(@NotNull String subChannelId, int segment, @NotNull ReadReceiptSyncState syncState, int retryCount) {
            Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
            Intrinsics.checkNotNullParameter((Object)((Object)syncState), (String)"syncState");
            return new ReadReceiptSyncJob(subChannelId, segment, syncState, retryCount);
        }

        public static /* synthetic */ ReadReceiptSyncJob copy$default(ReadReceiptSyncJob readReceiptSyncJob, String string, int n, ReadReceiptSyncState readReceiptSyncState, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = readReceiptSyncJob.subChannelId;
            }
            if ((n3 & 2) != 0) {
                n = readReceiptSyncJob.segment;
            }
            if ((n3 & 4) != 0) {
                readReceiptSyncState = readReceiptSyncJob.syncState;
            }
            if ((n3 & 8) != 0) {
                n2 = readReceiptSyncJob.retryCount;
            }
            return readReceiptSyncJob.copy(string, n, readReceiptSyncState, n2);
        }

        @NotNull
        public String toString() {
            return "ReadReceiptSyncJob(subChannelId=" + this.subChannelId + ", segment=" + this.segment + ", syncState=" + this.syncState + ", retryCount=" + this.retryCount + ")";
        }

        public int hashCode() {
            int result = this.subChannelId.hashCode();
            result = result * 31 + Integer.hashCode(this.segment);
            result = result * 31 + this.syncState.hashCode();
            result = result * 31 + Integer.hashCode(this.retryCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadReceiptSyncJob)) {
                return false;
            }
            ReadReceiptSyncJob readReceiptSyncJob = (ReadReceiptSyncJob)other;
            if (!Intrinsics.areEqual((Object)this.subChannelId, (Object)readReceiptSyncJob.subChannelId)) {
                return false;
            }
            if (this.segment != readReceiptSyncJob.segment) {
                return false;
            }
            if (this.syncState != readReceiptSyncJob.syncState) {
                return false;
            }
            return this.retryCount == readReceiptSyncJob.retryCount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/core/SubChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "", "<init>", "(Ljava/lang/String;I)V", "CREATED", "SYNCING", "amity-sdk_release"})
    public static final class ReadReceiptSyncState
    extends Enum<ReadReceiptSyncState> {
        public static final /* enum */ ReadReceiptSyncState CREATED = new ReadReceiptSyncState();
        public static final /* enum */ ReadReceiptSyncState SYNCING = new ReadReceiptSyncState();
        private static final /* synthetic */ ReadReceiptSyncState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReadReceiptSyncState[] values() {
            return (ReadReceiptSyncState[])$VALUES.clone();
        }

        public static ReadReceiptSyncState valueOf(String value) {
            return Enum.valueOf(ReadReceiptSyncState.class, value);
        }

        @NotNull
        public static EnumEntries<ReadReceiptSyncState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = readReceiptSyncStateArray = new ReadReceiptSyncState[]{ReadReceiptSyncState.CREATED, ReadReceiptSyncState.SYNCING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

